<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateHttpProfileReq StructType
 * @subpackage Structs
 */
class UpdateHttpProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The webServiceRootUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $webServiceRootUri;
    /**
     * Constructor method for UpdateHttpProfileReq
     * @uses UpdateHttpProfileReq::setNewName()
     * @uses UpdateHttpProfileReq::setWebServiceRootUri()
     * @param string $newName
     * @param string $webServiceRootUri
     */
    public function __construct($newName = null, $webServiceRootUri = null)
    {
        $this
            ->setNewName($newName)
            ->setWebServiceRootUri($webServiceRootUri);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateHttpProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get webServiceRootUri value
     * @return string|null
     */
    public function getWebServiceRootUri()
    {
        return $this->webServiceRootUri;
    }
    /**
     * Set webServiceRootUri value
     * @param string $webServiceRootUri
     * @return \StructType\UpdateHttpProfileReq
     */
    public function setWebServiceRootUri($webServiceRootUri = null)
    {
        // validation for constraint: string
        if (!is_null($webServiceRootUri) && !is_string($webServiceRootUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($webServiceRootUri)), __LINE__);
        }
        $this->webServiceRootUri = $webServiceRootUri;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateHttpProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
