<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateElinGroupReq StructType
 * @subpackage Structs
 */
class UpdateElinGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The removeElinNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveElinNumbers
     */
    public $removeElinNumbers;
    /**
     * The addElinNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddElinNumbers
     */
    public $addElinNumbers;
    /**
     * The elinNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ElinNumbers
     */
    public $elinNumbers;
    /**
     * Constructor method for UpdateElinGroupReq
     * @uses UpdateElinGroupReq::setNewName()
     * @uses UpdateElinGroupReq::setDescription()
     * @uses UpdateElinGroupReq::setRemoveElinNumbers()
     * @uses UpdateElinGroupReq::setAddElinNumbers()
     * @uses UpdateElinGroupReq::setElinNumbers()
     * @param string $newName
     * @param string $description
     * @param \StructType\RemoveElinNumbers $removeElinNumbers
     * @param \StructType\AddElinNumbers $addElinNumbers
     * @param \StructType\ElinNumbers $elinNumbers
     */
    public function __construct($newName = null, $description = null, \StructType\RemoveElinNumbers $removeElinNumbers = null, \StructType\AddElinNumbers $addElinNumbers = null, \StructType\ElinNumbers $elinNumbers = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRemoveElinNumbers($removeElinNumbers)
            ->setAddElinNumbers($addElinNumbers)
            ->setElinNumbers($elinNumbers);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateElinGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\UpdateElinGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get removeElinNumbers value
     * @return \StructType\RemoveElinNumbers|null
     */
    public function getRemoveElinNumbers()
    {
        return $this->removeElinNumbers;
    }
    /**
     * Set removeElinNumbers value
     * @param \StructType\RemoveElinNumbers $removeElinNumbers
     * @return \StructType\UpdateElinGroupReq
     */
    public function setRemoveElinNumbers(\StructType\RemoveElinNumbers $removeElinNumbers = null)
    {
        $this->removeElinNumbers = $removeElinNumbers;
        return $this;
    }
    /**
     * Get addElinNumbers value
     * @return \StructType\AddElinNumbers|null
     */
    public function getAddElinNumbers()
    {
        return $this->addElinNumbers;
    }
    /**
     * Set addElinNumbers value
     * @param \StructType\AddElinNumbers $addElinNumbers
     * @return \StructType\UpdateElinGroupReq
     */
    public function setAddElinNumbers(\StructType\AddElinNumbers $addElinNumbers = null)
    {
        $this->addElinNumbers = $addElinNumbers;
        return $this;
    }
    /**
     * Get elinNumbers value
     * @return \StructType\ElinNumbers|null
     */
    public function getElinNumbers()
    {
        return $this->elinNumbers;
    }
    /**
     * Set elinNumbers value
     * @param \StructType\ElinNumbers $elinNumbers
     * @return \StructType\UpdateElinGroupReq
     */
    public function setElinNumbers(\StructType\ElinNumbers $elinNumbers = null)
    {
        $this->elinNumbers = $elinNumbers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateElinGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
