<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateConferenceNowReq StructType
 * @subpackage Structs
 */
class UpdateConferenceNowReq extends APIRequest
{
    /**
     * The conferenceNowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $conferenceNowNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The newConferenceNowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newConferenceNowNumber;
    /**
     * The newRoutePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The maxWaitTimeForHost
     * Meta informations extracted from the WSDL
     * - default: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxWaitTimeForHost;
    /**
     * The MohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MohAudioSourceId;
    /**
     * Constructor method for UpdateConferenceNowReq
     * @uses UpdateConferenceNowReq::setConferenceNowNumber()
     * @uses UpdateConferenceNowReq::setUuid()
     * @uses UpdateConferenceNowReq::setRoutePartitionName()
     * @uses UpdateConferenceNowReq::setNewConferenceNowNumber()
     * @uses UpdateConferenceNowReq::setNewRoutePartitionName()
     * @uses UpdateConferenceNowReq::setDescription()
     * @uses UpdateConferenceNowReq::setMaxWaitTimeForHost()
     * @uses UpdateConferenceNowReq::setMohAudioSourceId()
     * @param string $conferenceNowNumber
     * @param string $uuid
     * @param \StructType\XFkType $routePartitionName
     * @param string $newConferenceNowNumber
     * @param \StructType\XFkType $newRoutePartitionName
     * @param string $description
     * @param string $maxWaitTimeForHost
     * @param string $mohAudioSourceId
     */
    public function __construct($conferenceNowNumber = null, $uuid = null, \StructType\XFkType $routePartitionName = null, $newConferenceNowNumber = null, \StructType\XFkType $newRoutePartitionName = null, $description = null, $maxWaitTimeForHost = '15', $mohAudioSourceId = null)
    {
        $this
            ->setConferenceNowNumber($conferenceNowNumber)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setNewConferenceNowNumber($newConferenceNowNumber)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setDescription($description)
            ->setMaxWaitTimeForHost($maxWaitTimeForHost)
            ->setMohAudioSourceId($mohAudioSourceId);
    }
    /**
     * Get conferenceNowNumber value
     * @return string
     */
    public function getConferenceNowNumber()
    {
        return $this->conferenceNowNumber;
    }
    /**
     * Set conferenceNowNumber value
     * @param string $conferenceNowNumber
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setConferenceNowNumber($conferenceNowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceNowNumber) && !is_string($conferenceNowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conferenceNowNumber)), __LINE__);
        }
        $this->conferenceNowNumber = $conferenceNowNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get newConferenceNowNumber value
     * @return string|null
     */
    public function getNewConferenceNowNumber()
    {
        return $this->newConferenceNowNumber;
    }
    /**
     * Set newConferenceNowNumber value
     * @param string $newConferenceNowNumber
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setNewConferenceNowNumber($newConferenceNowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($newConferenceNowNumber) && !is_string($newConferenceNowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newConferenceNowNumber)), __LINE__);
        }
        $this->newConferenceNowNumber = $newConferenceNowNumber;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $newRoutePartitionName
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setNewRoutePartitionName(\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get maxWaitTimeForHost value
     * @return string|null
     */
    public function getMaxWaitTimeForHost()
    {
        return $this->maxWaitTimeForHost;
    }
    /**
     * Set maxWaitTimeForHost value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxWaitTimeForHost
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setMaxWaitTimeForHost($maxWaitTimeForHost = '15')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxWaitTimeForHost)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxWaitTimeForHost, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxWaitTimeForHost = $maxWaitTimeForHost;
        return $this;
    }
    /**
     * Get MohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMohAudioSourceId()
    {
        return isset($this->MohAudioSourceId) ? $this->MohAudioSourceId : null;
    }
    /**
     * Set MohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mohAudioSourceId
     * @return \StructType\UpdateConferenceNowReq
     */
    public function setMohAudioSourceId($mohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($mohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($mohAudioSourceId) || (is_array($mohAudioSourceId) && empty($mohAudioSourceId))) {
            unset($this->MohAudioSourceId);
        } else {
            $this->MohAudioSourceId = $mohAudioSourceId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateConferenceNowReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
