<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCcdAdvertisingServiceReq StructType
 * @subpackage Structs
 */
class UpdateCcdAdvertisingServiceReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The hostDnGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $hostDnGroup;
    /**
     * The safSipTrunk
     * Meta informations extracted from the WSDL
     * - documentation: Either safSipTrunk, safH323Trunk or both should be configured while adding
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $safSipTrunk;
    /**
     * The safH323Trunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $safH323Trunk;
    /**
     * Constructor method for UpdateCcdAdvertisingServiceReq
     * @uses UpdateCcdAdvertisingServiceReq::setNewName()
     * @uses UpdateCcdAdvertisingServiceReq::setDescription()
     * @uses UpdateCcdAdvertisingServiceReq::setIsActivated()
     * @uses UpdateCcdAdvertisingServiceReq::setHostDnGroup()
     * @uses UpdateCcdAdvertisingServiceReq::setSafSipTrunk()
     * @uses UpdateCcdAdvertisingServiceReq::setSafH323Trunk()
     * @param string $newName
     * @param string $description
     * @param string $isActivated
     * @param \StructType\XFkType $hostDnGroup
     * @param \StructType\XFkType $safSipTrunk
     * @param \StructType\XFkType $safH323Trunk
     */
    public function __construct($newName = null, $description = null, $isActivated = null, \StructType\XFkType $hostDnGroup = null, \StructType\XFkType $safSipTrunk = null, \StructType\XFkType $safH323Trunk = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setHostDnGroup($hostDnGroup)
            ->setSafSipTrunk($safSipTrunk)
            ->setSafH323Trunk($safH323Trunk);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateCcdAdvertisingServiceReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateCcdAdvertisingServiceReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\UpdateCcdAdvertisingServiceReq
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get hostDnGroup value
     * @return \StructType\XFkType|null
     */
    public function getHostDnGroup()
    {
        return $this->hostDnGroup;
    }
    /**
     * Set hostDnGroup value
     * @param \StructType\XFkType $hostDnGroup
     * @return \StructType\UpdateCcdAdvertisingServiceReq
     */
    public function setHostDnGroup(\StructType\XFkType $hostDnGroup = null)
    {
        $this->hostDnGroup = $hostDnGroup;
        return $this;
    }
    /**
     * Get safSipTrunk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSafSipTrunk()
    {
        return isset($this->safSipTrunk) ? $this->safSipTrunk : null;
    }
    /**
     * Set safSipTrunk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $safSipTrunk
     * @return \StructType\UpdateCcdAdvertisingServiceReq
     */
    public function setSafSipTrunk(\StructType\XFkType $safSipTrunk = null)
    {
        if (is_null($safSipTrunk) || (is_array($safSipTrunk) && empty($safSipTrunk))) {
            unset($this->safSipTrunk);
        } else {
            $this->safSipTrunk = $safSipTrunk;
        }
        return $this;
    }
    /**
     * Get safH323Trunk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSafH323Trunk()
    {
        return isset($this->safH323Trunk) ? $this->safH323Trunk : null;
    }
    /**
     * Set safH323Trunk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $safH323Trunk
     * @return \StructType\UpdateCcdAdvertisingServiceReq
     */
    public function setSafH323Trunk(\StructType\XFkType $safH323Trunk = null)
    {
        if (is_null($safH323Trunk) || (is_array($safH323Trunk) && empty($safH323Trunk))) {
            unset($this->safH323Trunk);
        } else {
            $this->safH323Trunk = $safH323Trunk;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCcdAdvertisingServiceReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
