<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateBillingServerReq StructType
 * @subpackage Structs
 */
class UpdateBillingServerReq extends APIRequest
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The resendOnFailure
     * Meta informations extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $resendOnFailure;
    /**
     * The billingServerProtocol
     * Meta informations extracted from the WSDL
     * - default: SFTP
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $billingServerProtocol;
    /**
     * Constructor method for UpdateBillingServerReq
     * @uses UpdateBillingServerReq::setUuid()
     * @uses UpdateBillingServerReq::setUserId()
     * @uses UpdateBillingServerReq::setPassword()
     * @uses UpdateBillingServerReq::setResendOnFailure()
     * @uses UpdateBillingServerReq::setBillingServerProtocol()
     * @param string $uuid
     * @param string $userId
     * @param string $password
     * @param string $resendOnFailure
     * @param string $billingServerProtocol
     */
    public function __construct($uuid = null, $userId = null, $password = null, $resendOnFailure = true, $billingServerProtocol = 'SFTP')
    {
        $this
            ->setUuid($uuid)
            ->setUserId($userId)
            ->setPassword($password)
            ->setResendOnFailure($resendOnFailure)
            ->setBillingServerProtocol($billingServerProtocol);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateBillingServerReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\UpdateBillingServerReq
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\UpdateBillingServerReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get resendOnFailure value
     * @return string|null
     */
    public function getResendOnFailure()
    {
        return $this->resendOnFailure;
    }
    /**
     * Set resendOnFailure value
     * @param string $resendOnFailure
     * @return \StructType\UpdateBillingServerReq
     */
    public function setResendOnFailure($resendOnFailure = true)
    {
        // validation for constraint: pattern
        if (is_scalar($resendOnFailure) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($resendOnFailure, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($resendOnFailure) && !is_string($resendOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resendOnFailure)), __LINE__);
        }
        $this->resendOnFailure = $resendOnFailure;
        return $this;
    }
    /**
     * Get billingServerProtocol value
     * @return string|null
     */
    public function getBillingServerProtocol()
    {
        return $this->billingServerProtocol;
    }
    /**
     * Set billingServerProtocol value
     * @uses \EnumType\XBillingserverprotocol::valueIsValid()
     * @uses \EnumType\XBillingserverprotocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billingServerProtocol
     * @return \StructType\UpdateBillingServerReq
     */
    public function setBillingServerProtocol($billingServerProtocol = 'SFTP')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XBillingserverprotocol::valueIsValid($billingServerProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $billingServerProtocol, implode(', ', \EnumType\XBillingserverprotocol::getValidValues())), __LINE__);
        }
        $this->billingServerProtocol = $billingServerProtocol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateBillingServerReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
