<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for services StructType
 * @subpackage Structs
 */
class Services extends AbstractStructBase
{
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XSubscribedService[]
     */
    public $service;
    /**
     * Constructor method for services
     * @uses Services::setService()
     * @param \StructType\XSubscribedService[] $service
     */
    public function __construct(array $service = array())
    {
        $this
            ->setService($service);
    }
    /**
     * Get service value
     * @return \StructType\XSubscribedService[]|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @throws \InvalidArgumentException
     * @param \StructType\XSubscribedService[] $service
     * @return \StructType\Services
     */
    public function setService(array $service = array())
    {
        foreach ($service as $servicesServiceItem) {
            // validation for constraint: itemType
            if (!$servicesServiceItem instanceof \StructType\XSubscribedService) {
                throw new \InvalidArgumentException(sprintf('The service property can only contain items of \StructType\XSubscribedService, "%s" given', is_object($servicesServiceItem) ? get_class($servicesServiceItem) : gettype($servicesServiceItem)), __LINE__);
            }
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Add item to service value
     * @throws \InvalidArgumentException
     * @param \StructType\XSubscribedService $item
     * @return \StructType\Services
     */
    public function addToService(\StructType\XSubscribedService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XSubscribedService) {
            throw new \InvalidArgumentException(sprintf('The service property can only contain items of \StructType\XSubscribedService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Services
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
