<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeLocales StructType
 * @subpackage Structs
 */
class RemoveLocales extends XCommonMembersExtension
{
    /**
     * The locale
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XMobileVoiceMember[]
     */
    public $locale;
    /**
     * Constructor method for removeLocales
     * @uses RemoveLocales::setLocale()
     * @param \StructType\XMobileVoiceMember[] $locale
     */
    public function __construct(array $locale = array())
    {
        $this
            ->setLocale($locale);
    }
    /**
     * Get locale value
     * @return \StructType\XMobileVoiceMember[]
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @throws \InvalidArgumentException
     * @param \StructType\XMobileVoiceMember[] $locale
     * @return \StructType\RemoveLocales
     */
    public function setLocale(array $locale = array())
    {
        foreach ($locale as $removeLocalesLocaleItem) {
            // validation for constraint: itemType
            if (!$removeLocalesLocaleItem instanceof \StructType\XMobileVoiceMember) {
                throw new \InvalidArgumentException(sprintf('The locale property can only contain items of \StructType\XMobileVoiceMember, "%s" given', is_object($removeLocalesLocaleItem) ? get_class($removeLocalesLocaleItem) : gettype($removeLocalesLocaleItem)), __LINE__);
            }
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Add item to locale value
     * @throws \InvalidArgumentException
     * @param \StructType\XMobileVoiceMember $item
     * @return \StructType\RemoveLocales
     */
    public function addToLocale(\StructType\XMobileVoiceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XMobileVoiceMember) {
            throw new \InvalidArgumentException(sprintf('The locale property can only contain items of \StructType\XMobileVoiceMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->locale[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveLocales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
