<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeLines StructType
 * @subpackage Structs
 */
class RemoveLines extends AbstractStructBase
{
    /**
     * The line
     * Meta informations extracted from the WSDL
     * - documentation: An XLine is an entry in the DeviceNumPlanMap table. The actual directory number is referenced inside the XLine object by the "dirn" or "dirnId" element.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XPhoneLine[]
     */
    public $line;
    /**
     * The lineIdentifier
     * Meta informations extracted from the WSDL
     * - documentation: The lineIdentifier cannot be used with AddLines and RemoveLines.This tag is valid only for lines tag
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XNumplanIdentifier[]
     */
    public $lineIdentifier;
    /**
     * Constructor method for removeLines
     * @uses RemoveLines::setLine()
     * @uses RemoveLines::setLineIdentifier()
     * @param \StructType\XPhoneLine[] $line
     * @param \StructType\XNumplanIdentifier[] $lineIdentifier
     */
    public function __construct(array $line = array(), array $lineIdentifier = array())
    {
        $this
            ->setLine($line)
            ->setLineIdentifier($lineIdentifier);
    }
    /**
     * Get line value
     * @return \StructType\XPhoneLine[]
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @throws \InvalidArgumentException
     * @param \StructType\XPhoneLine[] $line
     * @return \StructType\RemoveLines
     */
    public function setLine(array $line = array())
    {
        foreach ($line as $removeLinesLineItem) {
            // validation for constraint: itemType
            if (!$removeLinesLineItem instanceof \StructType\XPhoneLine) {
                throw new \InvalidArgumentException(sprintf('The line property can only contain items of \StructType\XPhoneLine, "%s" given', is_object($removeLinesLineItem) ? get_class($removeLinesLineItem) : gettype($removeLinesLineItem)), __LINE__);
            }
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Add item to line value
     * @throws \InvalidArgumentException
     * @param \StructType\XPhoneLine $item
     * @return \StructType\RemoveLines
     */
    public function addToLine(\StructType\XPhoneLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPhoneLine) {
            throw new \InvalidArgumentException(sprintf('The line property can only contain items of \StructType\XPhoneLine, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->line[] = $item;
        return $this;
    }
    /**
     * Get lineIdentifier value
     * @return \StructType\XNumplanIdentifier[]
     */
    public function getLineIdentifier()
    {
        return $this->lineIdentifier;
    }
    /**
     * Set lineIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\XNumplanIdentifier[] $lineIdentifier
     * @return \StructType\RemoveLines
     */
    public function setLineIdentifier(array $lineIdentifier = array())
    {
        foreach ($lineIdentifier as $removeLinesLineIdentifierItem) {
            // validation for constraint: itemType
            if (!$removeLinesLineIdentifierItem instanceof \StructType\XNumplanIdentifier) {
                throw new \InvalidArgumentException(sprintf('The lineIdentifier property can only contain items of \StructType\XNumplanIdentifier, "%s" given', is_object($removeLinesLineIdentifierItem) ? get_class($removeLinesLineIdentifierItem) : gettype($removeLinesLineIdentifierItem)), __LINE__);
            }
        }
        $this->lineIdentifier = $lineIdentifier;
        return $this;
    }
    /**
     * Add item to lineIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\XNumplanIdentifier $item
     * @return \StructType\RemoveLines
     */
    public function addToLineIdentifier(\StructType\XNumplanIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XNumplanIdentifier) {
            throw new \InvalidArgumentException(sprintf('The lineIdentifier property can only contain items of \StructType\XNumplanIdentifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->lineIdentifier[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveLines
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
