<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUser StructType
 * @subpackage Structs
 */
class RUser extends AbstractStructBase
{
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The displayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The mailid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailid;
    /**
     * The department
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The manager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manager;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The associatedDevices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The primaryExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrimaryExtension
     */
    public $primaryExtension;
    /**
     * The associatedPc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $associatedPc;
    /**
     * The associatedGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The enableCti
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCti;
    /**
     * The digestCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The phoneProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PhoneProfiles
     */
    public $phoneProfiles;
    /**
     * The defaultProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $defaultProfile;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The enableMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWaitTime
     * Meta informations extracted from the WSDL
     * - documentation: Maximum wait time for Desk Pickup must be a number in the range 0 to 30000.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxDeskPickupWaitTime;
    /**
     * The remoteDestinationLimit
     * Meta informations extracted from the WSDL
     * - documentation: Remote Destination Limit must be a number in the range 1 to 10. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The associatedRemoteDestinationProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedRemoteDestinationProfiles
     */
    public $associatedRemoteDestinationProfiles;
    /**
     * The passwordCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The pinCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PinCredentials
     */
    public $pinCredentials;
    /**
     * The associatedTodAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedTodAccess
     */
    public $associatedTodAccess;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The enableEmcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEmcc;
    /**
     * The associatedCapfProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedCapfProfiles
     */
    public $associatedCapfProfiles;
    /**
     * The ctiControlledDeviceProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $patternPrecedence;
    /**
     * The numericUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numericUserId;
    /**
     * The mlppPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppPassword;
    /**
     * The customUserFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomUserFields
     */
    public $customUserFields;
    /**
     * The homeCluster
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndPresenceEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndPresenceEnable;
    /**
     * The serviceProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $serviceProfile;
    /**
     * The lineAppearanceAssociationForPresences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LineAppearanceAssociationForPresences
     */
    public $lineAppearanceAssociationForPresences;
    /**
     * The directoryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUri;
    /**
     * The telephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: This field also corresponds to the field 'Number Displayed in Directory' for the Quick User/phone Add page.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telephoneNumber;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The mobileNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mobileNumber;
    /**
     * The homeNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $homeNumber;
    /**
     * The pagerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pagerNumber;
    /**
     * The extensionsInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionsInfo
     */
    public $extensionsInfo;
    /**
     * The selfService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $selfService;
    /**
     * The userProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $userProfile;
    /**
     * The calendarPresence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $calendarPresence;
    /**
     * The ldapDirectoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ldapDirectoryName;
    /**
     * The userIdentity
     * Meta informations extracted from the WSDL
     * - documentation: Value should be of of the format user@domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userIdentity;
    /**
     * The nameDialing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nameDialing;
    /**
     * The ipccExtension
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for Controlled Devices so this tag is appropriate for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ipccExtension;
    /**
     * The convertUserAccount
     * Meta informations extracted from the WSDL
     * - documentation: These tags are for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $convertUserAccount;
    /**
     * The accountType
     * Meta informations extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies this is a Locally created user and a value of 'LDAP' implies this user is an LDAP Synchronized user
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountType;
    /**
     * The authenticationType
     * Meta informations extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies authentication will happen at CUCM and a value of 'LDAP' implies authentication will happen at the LDAP
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationType;
    /**
     * The enableUserToHostConferenceNow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUserToHostConferenceNow;
    /**
     * The attendeesAccessCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $attendeesAccessCode;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUser
     * @uses RUser::setFirstName()
     * @uses RUser::setDisplayName()
     * @uses RUser::setMiddleName()
     * @uses RUser::setLastName()
     * @uses RUser::setUserid()
     * @uses RUser::setPassword()
     * @uses RUser::setPin()
     * @uses RUser::setMailid()
     * @uses RUser::setDepartment()
     * @uses RUser::setManager()
     * @uses RUser::setUserLocale()
     * @uses RUser::setAssociatedDevices()
     * @uses RUser::setPrimaryExtension()
     * @uses RUser::setAssociatedPc()
     * @uses RUser::setAssociatedGroups()
     * @uses RUser::setEnableCti()
     * @uses RUser::setDigestCredentials()
     * @uses RUser::setPhoneProfiles()
     * @uses RUser::setDefaultProfile()
     * @uses RUser::setPresenceGroupName()
     * @uses RUser::setSubscribeCallingSearchSpaceName()
     * @uses RUser::setEnableMobility()
     * @uses RUser::setEnableMobileVoiceAccess()
     * @uses RUser::setMaxDeskPickupWaitTime()
     * @uses RUser::setRemoteDestinationLimit()
     * @uses RUser::setAssociatedRemoteDestinationProfiles()
     * @uses RUser::setPasswordCredentials()
     * @uses RUser::setPinCredentials()
     * @uses RUser::setAssociatedTodAccess()
     * @uses RUser::setStatus()
     * @uses RUser::setEnableEmcc()
     * @uses RUser::setAssociatedCapfProfiles()
     * @uses RUser::setCtiControlledDeviceProfiles()
     * @uses RUser::setPatternPrecedence()
     * @uses RUser::setNumericUserId()
     * @uses RUser::setMlppPassword()
     * @uses RUser::setCustomUserFields()
     * @uses RUser::setHomeCluster()
     * @uses RUser::setImAndPresenceEnable()
     * @uses RUser::setServiceProfile()
     * @uses RUser::setLineAppearanceAssociationForPresences()
     * @uses RUser::setDirectoryUri()
     * @uses RUser::setTelephoneNumber()
     * @uses RUser::setTitle()
     * @uses RUser::setMobileNumber()
     * @uses RUser::setHomeNumber()
     * @uses RUser::setPagerNumber()
     * @uses RUser::setExtensionsInfo()
     * @uses RUser::setSelfService()
     * @uses RUser::setUserProfile()
     * @uses RUser::setCalendarPresence()
     * @uses RUser::setLdapDirectoryName()
     * @uses RUser::setUserIdentity()
     * @uses RUser::setNameDialing()
     * @uses RUser::setIpccExtension()
     * @uses RUser::setConvertUserAccount()
     * @uses RUser::setAccountType()
     * @uses RUser::setAuthenticationType()
     * @uses RUser::setEnableUserToHostConferenceNow()
     * @uses RUser::setAttendeesAccessCode()
     * @uses RUser::setUuid()
     * @param string $firstName
     * @param string $displayName
     * @param string $middleName
     * @param string $lastName
     * @param string $userid
     * @param string $password
     * @param string $pin
     * @param string $mailid
     * @param string $department
     * @param string $manager
     * @param string $userLocale
     * @param \StructType\AssociatedDevices $associatedDevices
     * @param \StructType\PrimaryExtension $primaryExtension
     * @param string $associatedPc
     * @param \StructType\AssociatedGroups $associatedGroups
     * @param string $enableCti
     * @param string $digestCredentials
     * @param \StructType\PhoneProfiles $phoneProfiles
     * @param \StructType\XFkType $defaultProfile
     * @param \StructType\XFkType $presenceGroupName
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWaitTime
     * @param string $remoteDestinationLimit
     * @param \StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles
     * @param \StructType\PasswordCredentials $passwordCredentials
     * @param \StructType\PinCredentials $pinCredentials
     * @param \StructType\AssociatedTodAccess $associatedTodAccess
     * @param string $status
     * @param string $enableEmcc
     * @param \StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @param \StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $patternPrecedence
     * @param string $numericUserId
     * @param string $mlppPassword
     * @param \StructType\CustomUserFields $customUserFields
     * @param string $homeCluster
     * @param string $imAndPresenceEnable
     * @param \StructType\XFkType $serviceProfile
     * @param \StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @param string $directoryUri
     * @param string $telephoneNumber
     * @param string $title
     * @param string $mobileNumber
     * @param string $homeNumber
     * @param string $pagerNumber
     * @param \StructType\ExtensionsInfo $extensionsInfo
     * @param string $selfService
     * @param \StructType\XFkType $userProfile
     * @param string $calendarPresence
     * @param \StructType\XFkType $ldapDirectoryName
     * @param string $userIdentity
     * @param string $nameDialing
     * @param \StructType\XFkType $ipccExtension
     * @param \StructType\XFkType $convertUserAccount
     * @param string $accountType
     * @param string $authenticationType
     * @param string $enableUserToHostConferenceNow
     * @param string $attendeesAccessCode
     * @param string $uuid
     */
    public function __construct($firstName = null, $displayName = null, $middleName = null, $lastName = null, $userid = null, $password = null, $pin = null, $mailid = null, $department = null, $manager = null, $userLocale = null, \StructType\AssociatedDevices $associatedDevices = null, \StructType\PrimaryExtension $primaryExtension = null, $associatedPc = null, \StructType\AssociatedGroups $associatedGroups = null, $enableCti = null, $digestCredentials = null, \StructType\PhoneProfiles $phoneProfiles = null, \StructType\XFkType $defaultProfile = null, \StructType\XFkType $presenceGroupName = null, \StructType\XFkType $subscribeCallingSearchSpaceName = null, $enableMobility = null, $enableMobileVoiceAccess = null, $maxDeskPickupWaitTime = null, $remoteDestinationLimit = null, \StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles = null, \StructType\PasswordCredentials $passwordCredentials = null, \StructType\PinCredentials $pinCredentials = null, \StructType\AssociatedTodAccess $associatedTodAccess = null, $status = null, $enableEmcc = null, \StructType\AssociatedCapfProfiles $associatedCapfProfiles = null, \StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $patternPrecedence = null, $numericUserId = null, $mlppPassword = null, \StructType\CustomUserFields $customUserFields = null, $homeCluster = null, $imAndPresenceEnable = null, \StructType\XFkType $serviceProfile = null, \StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null, $directoryUri = null, $telephoneNumber = null, $title = null, $mobileNumber = null, $homeNumber = null, $pagerNumber = null, \StructType\ExtensionsInfo $extensionsInfo = null, $selfService = null, \StructType\XFkType $userProfile = null, $calendarPresence = null, \StructType\XFkType $ldapDirectoryName = null, $userIdentity = null, $nameDialing = null, \StructType\XFkType $ipccExtension = null, \StructType\XFkType $convertUserAccount = null, $accountType = null, $authenticationType = null, $enableUserToHostConferenceNow = null, $attendeesAccessCode = null, $uuid = null)
    {
        $this
            ->setFirstName($firstName)
            ->setDisplayName($displayName)
            ->setMiddleName($middleName)
            ->setLastName($lastName)
            ->setUserid($userid)
            ->setPassword($password)
            ->setPin($pin)
            ->setMailid($mailid)
            ->setDepartment($department)
            ->setManager($manager)
            ->setUserLocale($userLocale)
            ->setAssociatedDevices($associatedDevices)
            ->setPrimaryExtension($primaryExtension)
            ->setAssociatedPc($associatedPc)
            ->setAssociatedGroups($associatedGroups)
            ->setEnableCti($enableCti)
            ->setDigestCredentials($digestCredentials)
            ->setPhoneProfiles($phoneProfiles)
            ->setDefaultProfile($defaultProfile)
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWaitTime($maxDeskPickupWaitTime)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setAssociatedRemoteDestinationProfiles($associatedRemoteDestinationProfiles)
            ->setPasswordCredentials($passwordCredentials)
            ->setPinCredentials($pinCredentials)
            ->setAssociatedTodAccess($associatedTodAccess)
            ->setStatus($status)
            ->setEnableEmcc($enableEmcc)
            ->setAssociatedCapfProfiles($associatedCapfProfiles)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setPatternPrecedence($patternPrecedence)
            ->setNumericUserId($numericUserId)
            ->setMlppPassword($mlppPassword)
            ->setCustomUserFields($customUserFields)
            ->setHomeCluster($homeCluster)
            ->setImAndPresenceEnable($imAndPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setLineAppearanceAssociationForPresences($lineAppearanceAssociationForPresences)
            ->setDirectoryUri($directoryUri)
            ->setTelephoneNumber($telephoneNumber)
            ->setTitle($title)
            ->setMobileNumber($mobileNumber)
            ->setHomeNumber($homeNumber)
            ->setPagerNumber($pagerNumber)
            ->setExtensionsInfo($extensionsInfo)
            ->setSelfService($selfService)
            ->setUserProfile($userProfile)
            ->setCalendarPresence($calendarPresence)
            ->setLdapDirectoryName($ldapDirectoryName)
            ->setUserIdentity($userIdentity)
            ->setNameDialing($nameDialing)
            ->setIpccExtension($ipccExtension)
            ->setConvertUserAccount($convertUserAccount)
            ->setAccountType($accountType)
            ->setAuthenticationType($authenticationType)
            ->setEnableUserToHostConferenceNow($enableUserToHostConferenceNow)
            ->setAttendeesAccessCode($attendeesAccessCode)
            ->setUuid($uuid);
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\RUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\RUser
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\RUser
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\RUser
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\RUser
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\RUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \StructType\RUser
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get mailid value
     * @return string|null
     */
    public function getMailid()
    {
        return $this->mailid;
    }
    /**
     * Set mailid value
     * @param string $mailid
     * @return \StructType\RUser
     */
    public function setMailid($mailid = null)
    {
        // validation for constraint: string
        if (!is_null($mailid) && !is_string($mailid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailid)), __LINE__);
        }
        $this->mailid = $mailid;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \StructType\RUser
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \StructType\RUser
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses \EnumType\XUserLocale::valueIsValid()
     * @uses \EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \StructType\RUser
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', \EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \StructType\AssociatedDevices $associatedDevices
     * @return \StructType\RUser
     */
    public function setAssociatedDevices(\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get primaryExtension value
     * @return \StructType\PrimaryExtension|null
     */
    public function getPrimaryExtension()
    {
        return $this->primaryExtension;
    }
    /**
     * Set primaryExtension value
     * @param \StructType\PrimaryExtension $primaryExtension
     * @return \StructType\RUser
     */
    public function setPrimaryExtension(\StructType\PrimaryExtension $primaryExtension = null)
    {
        $this->primaryExtension = $primaryExtension;
        return $this;
    }
    /**
     * Get associatedPc value
     * @return string|null
     */
    public function getAssociatedPc()
    {
        return $this->associatedPc;
    }
    /**
     * Set associatedPc value
     * @param string $associatedPc
     * @return \StructType\RUser
     */
    public function setAssociatedPc($associatedPc = null)
    {
        // validation for constraint: string
        if (!is_null($associatedPc) && !is_string($associatedPc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($associatedPc)), __LINE__);
        }
        $this->associatedPc = $associatedPc;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \StructType\AssociatedGroups $associatedGroups
     * @return \StructType\RUser
     */
    public function setAssociatedGroups(\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get enableCti value
     * @return string|null
     */
    public function getEnableCti()
    {
        return $this->enableCti;
    }
    /**
     * Set enableCti value
     * @param string $enableCti
     * @return \StructType\RUser
     */
    public function setEnableCti($enableCti = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableCti) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableCti, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableCti) && !is_string($enableCti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCti)), __LINE__);
        }
        $this->enableCti = $enableCti;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \StructType\RUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestCredentials)), __LINE__);
        }
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get phoneProfiles value
     * @return \StructType\PhoneProfiles|null
     */
    public function getPhoneProfiles()
    {
        return $this->phoneProfiles;
    }
    /**
     * Set phoneProfiles value
     * @param \StructType\PhoneProfiles $phoneProfiles
     * @return \StructType\RUser
     */
    public function setPhoneProfiles(\StructType\PhoneProfiles $phoneProfiles = null)
    {
        $this->phoneProfiles = $phoneProfiles;
        return $this;
    }
    /**
     * Get defaultProfile value
     * @return \StructType\XFkType|null
     */
    public function getDefaultProfile()
    {
        return $this->defaultProfile;
    }
    /**
     * Set defaultProfile value
     * @param \StructType\XFkType $defaultProfile
     * @return \StructType\RUser
     */
    public function setDefaultProfile(\StructType\XFkType $defaultProfile = null)
    {
        $this->defaultProfile = $defaultProfile;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\XFkType $presenceGroupName
     * @return \StructType\RUser
     */
    public function setPresenceGroupName(\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \StructType\RUser
     */
    public function setSubscribeCallingSearchSpaceName(\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return \StructType\RUser
     */
    public function setEnableMobility($enableMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobility) && !is_string($enableMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobility)), __LINE__);
        }
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return \StructType\RUser
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileVoiceAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileVoiceAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileVoiceAccess) && !is_string($enableMobileVoiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileVoiceAccess)), __LINE__);
        }
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWaitTime value
     * @return string|null
     */
    public function getMaxDeskPickupWaitTime()
    {
        return $this->maxDeskPickupWaitTime;
    }
    /**
     * Set maxDeskPickupWaitTime value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxDeskPickupWaitTime
     * @return \StructType\RUser
     */
    public function setMaxDeskPickupWaitTime($maxDeskPickupWaitTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxDeskPickupWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxDeskPickupWaitTime, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxDeskPickupWaitTime = $maxDeskPickupWaitTime;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $remoteDestinationLimit
     * @return \StructType\RUser
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($remoteDestinationLimit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $remoteDestinationLimit, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get associatedRemoteDestinationProfiles value
     * @return \StructType\AssociatedRemoteDestinationProfiles|null
     */
    public function getAssociatedRemoteDestinationProfiles()
    {
        return $this->associatedRemoteDestinationProfiles;
    }
    /**
     * Set associatedRemoteDestinationProfiles value
     * @param \StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles
     * @return \StructType\RUser
     */
    public function setAssociatedRemoteDestinationProfiles(\StructType\AssociatedRemoteDestinationProfiles $associatedRemoteDestinationProfiles = null)
    {
        $this->associatedRemoteDestinationProfiles = $associatedRemoteDestinationProfiles;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \StructType\PasswordCredentials $passwordCredentials
     * @return \StructType\RUser
     */
    public function setPasswordCredentials(\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get pinCredentials value
     * @return \StructType\PinCredentials|null
     */
    public function getPinCredentials()
    {
        return $this->pinCredentials;
    }
    /**
     * Set pinCredentials value
     * @param \StructType\PinCredentials $pinCredentials
     * @return \StructType\RUser
     */
    public function setPinCredentials(\StructType\PinCredentials $pinCredentials = null)
    {
        $this->pinCredentials = $pinCredentials;
        return $this;
    }
    /**
     * Get associatedTodAccess value
     * @return \StructType\AssociatedTodAccess|null
     */
    public function getAssociatedTodAccess()
    {
        return $this->associatedTodAccess;
    }
    /**
     * Set associatedTodAccess value
     * @param \StructType\AssociatedTodAccess $associatedTodAccess
     * @return \StructType\RUser
     */
    public function setAssociatedTodAccess(\StructType\AssociatedTodAccess $associatedTodAccess = null)
    {
        $this->associatedTodAccess = $associatedTodAccess;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\RUser
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get enableEmcc value
     * @return string|null
     */
    public function getEnableEmcc()
    {
        return $this->enableEmcc;
    }
    /**
     * Set enableEmcc value
     * @param string $enableEmcc
     * @return \StructType\RUser
     */
    public function setEnableEmcc($enableEmcc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableEmcc) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableEmcc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableEmcc) && !is_string($enableEmcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableEmcc)), __LINE__);
        }
        $this->enableEmcc = $enableEmcc;
        return $this;
    }
    /**
     * Get associatedCapfProfiles value
     * @return \StructType\AssociatedCapfProfiles|null
     */
    public function getAssociatedCapfProfiles()
    {
        return $this->associatedCapfProfiles;
    }
    /**
     * Set associatedCapfProfiles value
     * @param \StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @return \StructType\RUser
     */
    public function setAssociatedCapfProfiles(\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null)
    {
        $this->associatedCapfProfiles = $associatedCapfProfiles;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \StructType\RUser
     */
    public function setCtiControlledDeviceProfiles(\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \EnumType\XPatternPrecedence::valueIsValid()
     * @uses \EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \StructType\RUser
     */
    public function setPatternPrecedence($patternPrecedence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternPrecedence, implode(', ', \EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get numericUserId value
     * @return string|null
     */
    public function getNumericUserId()
    {
        return $this->numericUserId;
    }
    /**
     * Set numericUserId value
     * @param string $numericUserId
     * @return \StructType\RUser
     */
    public function setNumericUserId($numericUserId = null)
    {
        // validation for constraint: string
        if (!is_null($numericUserId) && !is_string($numericUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numericUserId)), __LINE__);
        }
        $this->numericUserId = $numericUserId;
        return $this;
    }
    /**
     * Get mlppPassword value
     * @return string|null
     */
    public function getMlppPassword()
    {
        return $this->mlppPassword;
    }
    /**
     * Set mlppPassword value
     * @param string $mlppPassword
     * @return \StructType\RUser
     */
    public function setMlppPassword($mlppPassword = null)
    {
        // validation for constraint: string
        if (!is_null($mlppPassword) && !is_string($mlppPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppPassword)), __LINE__);
        }
        $this->mlppPassword = $mlppPassword;
        return $this;
    }
    /**
     * Get customUserFields value
     * @return \StructType\CustomUserFields|null
     */
    public function getCustomUserFields()
    {
        return $this->customUserFields;
    }
    /**
     * Set customUserFields value
     * @param \StructType\CustomUserFields $customUserFields
     * @return \StructType\RUser
     */
    public function setCustomUserFields(\StructType\CustomUserFields $customUserFields = null)
    {
        $this->customUserFields = $customUserFields;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return \StructType\RUser
     */
    public function setHomeCluster($homeCluster = null)
    {
        // validation for constraint: pattern
        if (is_scalar($homeCluster) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($homeCluster, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($homeCluster) && !is_string($homeCluster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeCluster)), __LINE__);
        }
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndPresenceEnable value
     * @return string|null
     */
    public function getImAndPresenceEnable()
    {
        return $this->imAndPresenceEnable;
    }
    /**
     * Set imAndPresenceEnable value
     * @param string $imAndPresenceEnable
     * @return \StructType\RUser
     */
    public function setImAndPresenceEnable($imAndPresenceEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($imAndPresenceEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($imAndPresenceEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($imAndPresenceEnable) && !is_string($imAndPresenceEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imAndPresenceEnable)), __LINE__);
        }
        $this->imAndPresenceEnable = $imAndPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * @return \StructType\XFkType|null
     */
    public function getServiceProfile()
    {
        return $this->serviceProfile;
    }
    /**
     * Set serviceProfile value
     * @param \StructType\XFkType $serviceProfile
     * @return \StructType\RUser
     */
    public function setServiceProfile(\StructType\XFkType $serviceProfile = null)
    {
        $this->serviceProfile = $serviceProfile;
        return $this;
    }
    /**
     * Get lineAppearanceAssociationForPresences value
     * @return \StructType\LineAppearanceAssociationForPresences|null
     */
    public function getLineAppearanceAssociationForPresences()
    {
        return $this->lineAppearanceAssociationForPresences;
    }
    /**
     * Set lineAppearanceAssociationForPresences value
     * @param \StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @return \StructType\RUser
     */
    public function setLineAppearanceAssociationForPresences(\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null)
    {
        $this->lineAppearanceAssociationForPresences = $lineAppearanceAssociationForPresences;
        return $this;
    }
    /**
     * Get directoryUri value
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * Set directoryUri value
     * @param string $directoryUri
     * @return \StructType\RUser
     */
    public function setDirectoryUri($directoryUri = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUri) && !is_string($directoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryUri)), __LINE__);
        }
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\RUser
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\RUser
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get mobileNumber value
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->mobileNumber;
    }
    /**
     * Set mobileNumber value
     * @param string $mobileNumber
     * @return \StructType\RUser
     */
    public function setMobileNumber($mobileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNumber) && !is_string($mobileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobileNumber)), __LINE__);
        }
        $this->mobileNumber = $mobileNumber;
        return $this;
    }
    /**
     * Get homeNumber value
     * @return string|null
     */
    public function getHomeNumber()
    {
        return $this->homeNumber;
    }
    /**
     * Set homeNumber value
     * @param string $homeNumber
     * @return \StructType\RUser
     */
    public function setHomeNumber($homeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homeNumber) && !is_string($homeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homeNumber)), __LINE__);
        }
        $this->homeNumber = $homeNumber;
        return $this;
    }
    /**
     * Get pagerNumber value
     * @return string|null
     */
    public function getPagerNumber()
    {
        return $this->pagerNumber;
    }
    /**
     * Set pagerNumber value
     * @param string $pagerNumber
     * @return \StructType\RUser
     */
    public function setPagerNumber($pagerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pagerNumber) && !is_string($pagerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pagerNumber)), __LINE__);
        }
        $this->pagerNumber = $pagerNumber;
        return $this;
    }
    /**
     * Get extensionsInfo value
     * @return \StructType\ExtensionsInfo|null
     */
    public function getExtensionsInfo()
    {
        return $this->extensionsInfo;
    }
    /**
     * Set extensionsInfo value
     * @param \StructType\ExtensionsInfo $extensionsInfo
     * @return \StructType\RUser
     */
    public function setExtensionsInfo(\StructType\ExtensionsInfo $extensionsInfo = null)
    {
        $this->extensionsInfo = $extensionsInfo;
        return $this;
    }
    /**
     * Get selfService value
     * @return string|null
     */
    public function getSelfService()
    {
        return $this->selfService;
    }
    /**
     * Set selfService value
     * @param string $selfService
     * @return \StructType\RUser
     */
    public function setSelfService($selfService = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($selfService) && strlen($selfService) > 50) || (is_array($selfService) && count($selfService) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($selfService) ? strlen($selfService) : count($selfService)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($selfService) && !is_string($selfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selfService)), __LINE__);
        }
        $this->selfService = $selfService;
        return $this;
    }
    /**
     * Get userProfile value
     * @return \StructType\XFkType|null
     */
    public function getUserProfile()
    {
        return $this->userProfile;
    }
    /**
     * Set userProfile value
     * @param \StructType\XFkType $userProfile
     * @return \StructType\RUser
     */
    public function setUserProfile(\StructType\XFkType $userProfile = null)
    {
        $this->userProfile = $userProfile;
        return $this;
    }
    /**
     * Get calendarPresence value
     * @return string|null
     */
    public function getCalendarPresence()
    {
        return $this->calendarPresence;
    }
    /**
     * Set calendarPresence value
     * @param string $calendarPresence
     * @return \StructType\RUser
     */
    public function setCalendarPresence($calendarPresence = null)
    {
        // validation for constraint: pattern
        if (is_scalar($calendarPresence) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($calendarPresence, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calendarPresence) && !is_string($calendarPresence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calendarPresence)), __LINE__);
        }
        $this->calendarPresence = $calendarPresence;
        return $this;
    }
    /**
     * Get ldapDirectoryName value
     * @return \StructType\XFkType|null
     */
    public function getLdapDirectoryName()
    {
        return $this->ldapDirectoryName;
    }
    /**
     * Set ldapDirectoryName value
     * @param \StructType\XFkType $ldapDirectoryName
     * @return \StructType\RUser
     */
    public function setLdapDirectoryName(\StructType\XFkType $ldapDirectoryName = null)
    {
        $this->ldapDirectoryName = $ldapDirectoryName;
        return $this;
    }
    /**
     * Get userIdentity value
     * @return string|null
     */
    public function getUserIdentity()
    {
        return $this->userIdentity;
    }
    /**
     * Set userIdentity value
     * @param string $userIdentity
     * @return \StructType\RUser
     */
    public function setUserIdentity($userIdentity = null)
    {
        // validation for constraint: string
        if (!is_null($userIdentity) && !is_string($userIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userIdentity)), __LINE__);
        }
        $this->userIdentity = $userIdentity;
        return $this;
    }
    /**
     * Get nameDialing value
     * @return string|null
     */
    public function getNameDialing()
    {
        return $this->nameDialing;
    }
    /**
     * Set nameDialing value
     * @param string $nameDialing
     * @return \StructType\RUser
     */
    public function setNameDialing($nameDialing = null)
    {
        // validation for constraint: string
        if (!is_null($nameDialing) && !is_string($nameDialing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameDialing)), __LINE__);
        }
        $this->nameDialing = $nameDialing;
        return $this;
    }
    /**
     * Get ipccExtension value
     * @return \StructType\XFkType|null
     */
    public function getIpccExtension()
    {
        return $this->ipccExtension;
    }
    /**
     * Set ipccExtension value
     * @param \StructType\XFkType $ipccExtension
     * @return \StructType\RUser
     */
    public function setIpccExtension(\StructType\XFkType $ipccExtension = null)
    {
        $this->ipccExtension = $ipccExtension;
        return $this;
    }
    /**
     * Get convertUserAccount value
     * @return \StructType\XFkType|null
     */
    public function getConvertUserAccount()
    {
        return $this->convertUserAccount;
    }
    /**
     * Set convertUserAccount value
     * @param \StructType\XFkType $convertUserAccount
     * @return \StructType\RUser
     */
    public function setConvertUserAccount(\StructType\XFkType $convertUserAccount = null)
    {
        $this->convertUserAccount = $convertUserAccount;
        return $this;
    }
    /**
     * Get accountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @uses \EnumType\XAccountType::valueIsValid()
     * @uses \EnumType\XAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return \StructType\RUser
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAccountType::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountType, implode(', ', \EnumType\XAccountType::getValidValues())), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get authenticationType value
     * @return string|null
     */
    public function getAuthenticationType()
    {
        return $this->authenticationType;
    }
    /**
     * Set authenticationType value
     * @uses \EnumType\XAuthenticationType::valueIsValid()
     * @uses \EnumType\XAuthenticationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationType
     * @return \StructType\RUser
     */
    public function setAuthenticationType($authenticationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationType::valueIsValid($authenticationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationType, implode(', ', \EnumType\XAuthenticationType::getValidValues())), __LINE__);
        }
        $this->authenticationType = $authenticationType;
        return $this;
    }
    /**
     * Get enableUserToHostConferenceNow value
     * @return string|null
     */
    public function getEnableUserToHostConferenceNow()
    {
        return $this->enableUserToHostConferenceNow;
    }
    /**
     * Set enableUserToHostConferenceNow value
     * @param string $enableUserToHostConferenceNow
     * @return \StructType\RUser
     */
    public function setEnableUserToHostConferenceNow($enableUserToHostConferenceNow = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableUserToHostConferenceNow) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableUserToHostConferenceNow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableUserToHostConferenceNow, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableUserToHostConferenceNow) && !is_string($enableUserToHostConferenceNow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUserToHostConferenceNow)), __LINE__);
        }
        $this->enableUserToHostConferenceNow = $enableUserToHostConferenceNow;
        return $this;
    }
    /**
     * Get attendeesAccessCode value
     * @return string|null
     */
    public function getAttendeesAccessCode()
    {
        return $this->attendeesAccessCode;
    }
    /**
     * Set attendeesAccessCode value
     * @param string $attendeesAccessCode
     * @return \StructType\RUser
     */
    public function setAttendeesAccessCode($attendeesAccessCode = null)
    {
        // validation for constraint: string
        if (!is_null($attendeesAccessCode) && !is_string($attendeesAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attendeesAccessCode)), __LINE__);
        }
        $this->attendeesAccessCode = $attendeesAccessCode;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
