<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTimeScheduleTimePeriod StructType
 * @subpackage Structs
 */
class RTimeScheduleTimePeriod extends AbstractStructBase
{
    /**
     * The timePeriodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $timePeriodName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTimeScheduleTimePeriod
     * @uses RTimeScheduleTimePeriod::setTimePeriodName()
     * @uses RTimeScheduleTimePeriod::setUuid()
     * @param \StructType\XFkType $timePeriodName
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $timePeriodName = null, $uuid = null)
    {
        $this
            ->setTimePeriodName($timePeriodName)
            ->setUuid($uuid);
    }
    /**
     * Get timePeriodName value
     * @return \StructType\XFkType|null
     */
    public function getTimePeriodName()
    {
        return $this->timePeriodName;
    }
    /**
     * Set timePeriodName value
     * @param \StructType\XFkType $timePeriodName
     * @return \StructType\RTimeScheduleTimePeriod
     */
    public function setTimePeriodName(\StructType\XFkType $timePeriodName = null)
    {
        $this->timePeriodName = $timePeriodName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RTimeScheduleTimePeriod
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RTimeScheduleTimePeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
