<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSNMPUser StructType
 * @subpackage Structs
 */
class RSNMPUser extends AbstractStructBase
{
    /**
     * The userName
     * @var string
     */
    public $userName;
    /**
     * The authRequired
     * Meta informations extracted from the WSDL
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $authRequired;
    /**
     * The authPassword
     * @var string
     */
    public $authPassword;
    /**
     * The authProtocol
     * @var string
     */
    public $authProtocol;
    /**
     * The privacyRequired
     * Meta informations extracted from the WSDL
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $privacyRequired;
    /**
     * The privacyPassword
     * @var string
     */
    public $privacyPassword;
    /**
     * The privacyProtocol
     * @var string
     */
    public $privacyProtocol;
    /**
     * The accessPrivilege
     * @var string
     */
    public $accessPrivilege;
    /**
     * The ArrayOfHosts
     * @var \ArrayType\RArrayOfHosts
     */
    public $ArrayOfHosts;
    /**
     * Constructor method for RSNMPUser
     * @uses RSNMPUser::setUserName()
     * @uses RSNMPUser::setAuthRequired()
     * @uses RSNMPUser::setAuthPassword()
     * @uses RSNMPUser::setAuthProtocol()
     * @uses RSNMPUser::setPrivacyRequired()
     * @uses RSNMPUser::setPrivacyPassword()
     * @uses RSNMPUser::setPrivacyProtocol()
     * @uses RSNMPUser::setAccessPrivilege()
     * @uses RSNMPUser::setArrayOfHosts()
     * @param string $userName
     * @param string $authRequired
     * @param string $authPassword
     * @param string $authProtocol
     * @param string $privacyRequired
     * @param string $privacyPassword
     * @param string $privacyProtocol
     * @param string $accessPrivilege
     * @param \ArrayType\RArrayOfHosts $arrayOfHosts
     */
    public function __construct($userName = null, $authRequired = null, $authPassword = null, $authProtocol = null, $privacyRequired = null, $privacyPassword = null, $privacyProtocol = null, $accessPrivilege = null, \ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this
            ->setUserName($userName)
            ->setAuthRequired($authRequired)
            ->setAuthPassword($authPassword)
            ->setAuthProtocol($authProtocol)
            ->setPrivacyRequired($privacyRequired)
            ->setPrivacyPassword($privacyPassword)
            ->setPrivacyProtocol($privacyProtocol)
            ->setAccessPrivilege($accessPrivilege)
            ->setArrayOfHosts($arrayOfHosts);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\RSNMPUser
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get authRequired value
     * @return string|null
     */
    public function getAuthRequired()
    {
        return $this->authRequired;
    }
    /**
     * Set authRequired value
     * @param string $authRequired
     * @return \StructType\RSNMPUser
     */
    public function setAuthRequired($authRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($authRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $authRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($authRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authRequired) && !is_string($authRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authRequired)), __LINE__);
        }
        $this->authRequired = $authRequired;
        return $this;
    }
    /**
     * Get authPassword value
     * @return string|null
     */
    public function getAuthPassword()
    {
        return $this->authPassword;
    }
    /**
     * Set authPassword value
     * @param string $authPassword
     * @return \StructType\RSNMPUser
     */
    public function setAuthPassword($authPassword = null)
    {
        // validation for constraint: string
        if (!is_null($authPassword) && !is_string($authPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPassword)), __LINE__);
        }
        $this->authPassword = $authPassword;
        return $this;
    }
    /**
     * Get authProtocol value
     * @return string|null
     */
    public function getAuthProtocol()
    {
        return $this->authProtocol;
    }
    /**
     * Set authProtocol value
     * @param string $authProtocol
     * @return \StructType\RSNMPUser
     */
    public function setAuthProtocol($authProtocol = null)
    {
        // validation for constraint: string
        if (!is_null($authProtocol) && !is_string($authProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authProtocol)), __LINE__);
        }
        $this->authProtocol = $authProtocol;
        return $this;
    }
    /**
     * Get privacyRequired value
     * @return string|null
     */
    public function getPrivacyRequired()
    {
        return $this->privacyRequired;
    }
    /**
     * Set privacyRequired value
     * @param string $privacyRequired
     * @return \StructType\RSNMPUser
     */
    public function setPrivacyRequired($privacyRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($privacyRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $privacyRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($privacyRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($privacyRequired) && !is_string($privacyRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privacyRequired)), __LINE__);
        }
        $this->privacyRequired = $privacyRequired;
        return $this;
    }
    /**
     * Get privacyPassword value
     * @return string|null
     */
    public function getPrivacyPassword()
    {
        return $this->privacyPassword;
    }
    /**
     * Set privacyPassword value
     * @param string $privacyPassword
     * @return \StructType\RSNMPUser
     */
    public function setPrivacyPassword($privacyPassword = null)
    {
        // validation for constraint: string
        if (!is_null($privacyPassword) && !is_string($privacyPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privacyPassword)), __LINE__);
        }
        $this->privacyPassword = $privacyPassword;
        return $this;
    }
    /**
     * Get privacyProtocol value
     * @return string|null
     */
    public function getPrivacyProtocol()
    {
        return $this->privacyProtocol;
    }
    /**
     * Set privacyProtocol value
     * @param string $privacyProtocol
     * @return \StructType\RSNMPUser
     */
    public function setPrivacyProtocol($privacyProtocol = null)
    {
        // validation for constraint: string
        if (!is_null($privacyProtocol) && !is_string($privacyProtocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privacyProtocol)), __LINE__);
        }
        $this->privacyProtocol = $privacyProtocol;
        return $this;
    }
    /**
     * Get accessPrivilege value
     * @return string|null
     */
    public function getAccessPrivilege()
    {
        return $this->accessPrivilege;
    }
    /**
     * Set accessPrivilege value
     * @param string $accessPrivilege
     * @return \StructType\RSNMPUser
     */
    public function setAccessPrivilege($accessPrivilege = null)
    {
        // validation for constraint: string
        if (!is_null($accessPrivilege) && !is_string($accessPrivilege)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessPrivilege)), __LINE__);
        }
        $this->accessPrivilege = $accessPrivilege;
        return $this;
    }
    /**
     * Get ArrayOfHosts value
     * @return \ArrayType\RArrayOfHosts|null
     */
    public function getArrayOfHosts()
    {
        return $this->ArrayOfHosts;
    }
    /**
     * Set ArrayOfHosts value
     * @param \ArrayType\RArrayOfHosts $arrayOfHosts
     * @return \StructType\RSNMPUser
     */
    public function setArrayOfHosts(\ArrayType\RArrayOfHosts $arrayOfHosts = null)
    {
        $this->ArrayOfHosts = $arrayOfHosts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RSNMPUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
