<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRemoteClusterMember StructType
 * @subpackage Structs
 */
class RRemoteClusterMember extends AbstractStructBase
{
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The remoteIpAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $remoteIpAddress1;
    /**
     * The remoteIpAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $remoteIpAddress2;
    /**
     * The remoteIpAddress3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $remoteIpAddress3;
    /**
     * Constructor method for RRemoteClusterMember
     * @uses RRemoteClusterMember::setEnabled()
     * @uses RRemoteClusterMember::setRemoteIpAddress1()
     * @uses RRemoteClusterMember::setRemoteIpAddress2()
     * @uses RRemoteClusterMember::setRemoteIpAddress3()
     * @param string $enabled
     * @param string $remoteIpAddress1
     * @param string $remoteIpAddress2
     * @param string $remoteIpAddress3
     */
    public function __construct($enabled = null, $remoteIpAddress1 = null, $remoteIpAddress2 = null, $remoteIpAddress3 = null)
    {
        $this
            ->setEnabled($enabled)
            ->setRemoteIpAddress1($remoteIpAddress1)
            ->setRemoteIpAddress2($remoteIpAddress2)
            ->setRemoteIpAddress3($remoteIpAddress3);
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \StructType\RRemoteClusterMember
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get remoteIpAddress1 value
     * @return string|null
     */
    public function getRemoteIpAddress1()
    {
        return $this->remoteIpAddress1;
    }
    /**
     * Set remoteIpAddress1 value
     * @param string $remoteIpAddress1
     * @return \StructType\RRemoteClusterMember
     */
    public function setRemoteIpAddress1($remoteIpAddress1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($remoteIpAddress1) && strlen($remoteIpAddress1) > 15) || (is_array($remoteIpAddress1) && count($remoteIpAddress1) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($remoteIpAddress1) ? strlen($remoteIpAddress1) : count($remoteIpAddress1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteIpAddress1) && !is_string($remoteIpAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteIpAddress1)), __LINE__);
        }
        $this->remoteIpAddress1 = $remoteIpAddress1;
        return $this;
    }
    /**
     * Get remoteIpAddress2 value
     * @return string|null
     */
    public function getRemoteIpAddress2()
    {
        return $this->remoteIpAddress2;
    }
    /**
     * Set remoteIpAddress2 value
     * @param string $remoteIpAddress2
     * @return \StructType\RRemoteClusterMember
     */
    public function setRemoteIpAddress2($remoteIpAddress2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($remoteIpAddress2) && strlen($remoteIpAddress2) > 15) || (is_array($remoteIpAddress2) && count($remoteIpAddress2) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($remoteIpAddress2) ? strlen($remoteIpAddress2) : count($remoteIpAddress2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteIpAddress2) && !is_string($remoteIpAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteIpAddress2)), __LINE__);
        }
        $this->remoteIpAddress2 = $remoteIpAddress2;
        return $this;
    }
    /**
     * Get remoteIpAddress3 value
     * @return string|null
     */
    public function getRemoteIpAddress3()
    {
        return $this->remoteIpAddress3;
    }
    /**
     * Set remoteIpAddress3 value
     * @param string $remoteIpAddress3
     * @return \StructType\RRemoteClusterMember
     */
    public function setRemoteIpAddress3($remoteIpAddress3 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($remoteIpAddress3) && strlen($remoteIpAddress3) > 15) || (is_array($remoteIpAddress3) && count($remoteIpAddress3) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($remoteIpAddress3) ? strlen($remoteIpAddress3) : count($remoteIpAddress3)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteIpAddress3) && !is_string($remoteIpAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteIpAddress3)), __LINE__);
        }
        $this->remoteIpAddress3 = $remoteIpAddress3;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RRemoteClusterMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
