<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPresenceGroupMember StructType
 * @subpackage Structs
 */
class RPresenceGroupMember extends AbstractStructBase
{
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscriptionPermission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriptionPermission;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPresenceGroupMember
     * @uses RPresenceGroupMember::setPresenceGroupName()
     * @uses RPresenceGroupMember::setSubscriptionPermission()
     * @uses RPresenceGroupMember::setUuid()
     * @param \StructType\XFkType $presenceGroupName
     * @param string $subscriptionPermission
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $presenceGroupName = null, $subscriptionPermission = null, $uuid = null)
    {
        $this
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscriptionPermission($subscriptionPermission)
            ->setUuid($uuid);
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\XFkType $presenceGroupName
     * @return \StructType\RPresenceGroupMember
     */
    public function setPresenceGroupName(\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscriptionPermission value
     * @return string|null
     */
    public function getSubscriptionPermission()
    {
        return $this->subscriptionPermission;
    }
    /**
     * Set subscriptionPermission value
     * @uses \EnumType\XMatrixValue::valueIsValid()
     * @uses \EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionPermission
     * @return \StructType\RPresenceGroupMember
     */
    public function setSubscriptionPermission($subscriptionPermission = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMatrixValue::valueIsValid($subscriptionPermission)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriptionPermission, implode(', ', \EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->subscriptionPermission = $subscriptionPermission;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RPresenceGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RPresenceGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
