<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RParameterMember StructType
 * @subpackage Structs
 */
class RParameterMember extends AbstractStructBase
{
    /**
     * The parameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameter;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for RParameterMember
     * @uses RParameterMember::setParameter()
     * @uses RParameterMember::setValue()
     * @uses RParameterMember::setSelectionOrder()
     * @param string $parameter
     * @param string $value
     * @param string $selectionOrder
     */
    public function __construct($parameter = null, $value = null, $selectionOrder = null)
    {
        $this
            ->setParameter($parameter)
            ->setValue($value)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @uses \EnumType\XDialParameter::valueIsValid()
     * @uses \EnumType\XDialParameter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parameter
     * @return \StructType\RParameterMember
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDialParameter::valueIsValid($parameter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parameter, implode(', ', \EnumType\XDialParameter::getValidValues())), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\RParameterMember
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\RParameterMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RParameterMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
