<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RIpPhoneServices StructType
 * @subpackage Structs
 */
class RIpPhoneServices extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $serviceName;
    /**
     * The asciiServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $serviceDescription;
    /**
     * The serviceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceUrl;
    /**
     * The secureServiceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The serviceVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The enterpriseSubscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enterpriseSubscription;
    /**
     * The parameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Parameters
     */
    public $parameters;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RIpPhoneServices
     * @uses RIpPhoneServices::setServiceName()
     * @uses RIpPhoneServices::setAsciiServiceName()
     * @uses RIpPhoneServices::setServiceDescription()
     * @uses RIpPhoneServices::setServiceUrl()
     * @uses RIpPhoneServices::setSecureServiceUrl()
     * @uses RIpPhoneServices::setServiceCategory()
     * @uses RIpPhoneServices::setServiceType()
     * @uses RIpPhoneServices::setServiceVendor()
     * @uses RIpPhoneServices::setServiceVersion()
     * @uses RIpPhoneServices::setEnabled()
     * @uses RIpPhoneServices::setEnterpriseSubscription()
     * @uses RIpPhoneServices::setParameters()
     * @uses RIpPhoneServices::setUuid()
     * @param string $serviceName
     * @param string $asciiServiceName
     * @param string $serviceDescription
     * @param string $serviceUrl
     * @param string $secureServiceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param string $enterpriseSubscription
     * @param \StructType\Parameters $parameters
     * @param string $uuid
     */
    public function __construct($serviceName = null, $asciiServiceName = null, $serviceDescription = null, $serviceUrl = null, $secureServiceUrl = null, $serviceCategory = null, $serviceType = null, $serviceVendor = null, $serviceVersion = null, $enabled = null, $enterpriseSubscription = null, \StructType\Parameters $parameters = null, $uuid = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceDescription($serviceDescription)
            ->setServiceUrl($serviceUrl)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setEnterpriseSubscription($enterpriseSubscription)
            ->setParameters($parameters)
            ->setUuid($uuid);
    }
    /**
     * Get serviceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \StructType\RIpPhoneServices
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceName) && strlen($serviceName) > 128) || (is_array($serviceName) && count($serviceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($serviceName) ? strlen($serviceName) : count($serviceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string|null
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return \StructType\RIpPhoneServices
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiServiceName) && strlen($asciiServiceName) > 128) || (is_array($asciiServiceName) && count($asciiServiceName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($asciiServiceName) ? strlen($asciiServiceName) : count($asciiServiceName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiServiceName) && !is_string($asciiServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiServiceName)), __LINE__);
        }
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceDescription value
     * @return string|null
     */
    public function getServiceDescription()
    {
        return $this->serviceDescription;
    }
    /**
     * Set serviceDescription value
     * @param string $serviceDescription
     * @return \StructType\RIpPhoneServices
     */
    public function setServiceDescription($serviceDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceDescription) && strlen($serviceDescription) > 128) || (is_array($serviceDescription) && count($serviceDescription) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($serviceDescription) ? strlen($serviceDescription) : count($serviceDescription)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceDescription) && !is_string($serviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceDescription)), __LINE__);
        }
        $this->serviceDescription = $serviceDescription;
        return $this;
    }
    /**
     * Get serviceUrl value
     * @return string|null
     */
    public function getServiceUrl()
    {
        return $this->serviceUrl;
    }
    /**
     * Set serviceUrl value
     * @param string $serviceUrl
     * @return \StructType\RIpPhoneServices
     */
    public function setServiceUrl($serviceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($serviceUrl) && !is_string($serviceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceUrl)), __LINE__);
        }
        $this->serviceUrl = $serviceUrl;
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return $this->secureServiceUrl;
    }
    /**
     * Set secureServiceUrl value
     * @param string $secureServiceUrl
     * @return \StructType\RIpPhoneServices
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        // validation for constraint: string
        if (!is_null($secureServiceUrl) && !is_string($secureServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServiceUrl)), __LINE__);
        }
        $this->secureServiceUrl = $secureServiceUrl;
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string|null
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @uses \EnumType\XPhoneServiceCategory::valueIsValid()
     * @uses \EnumType\XPhoneServiceCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCategory
     * @return \StructType\RIpPhoneServices
     */
    public function setServiceCategory($serviceCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneServiceCategory::valueIsValid($serviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceCategory, implode(', ', \EnumType\XPhoneServiceCategory::getValidValues())), __LINE__);
        }
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\XPhoneService::valueIsValid()
     * @uses \EnumType\XPhoneService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\RIpPhoneServices
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPhoneService::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\XPhoneService::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return \StructType\RIpPhoneServices
     */
    public function setServiceVendor($serviceVendor = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVendor) && !is_string($serviceVendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceVendor)), __LINE__);
        }
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return \StructType\RIpPhoneServices
     */
    public function setServiceVersion($serviceVersion = null)
    {
        // validation for constraint: string
        if (!is_null($serviceVersion) && !is_string($serviceVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceVersion)), __LINE__);
        }
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \StructType\RIpPhoneServices
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get enterpriseSubscription value
     * @return string|null
     */
    public function getEnterpriseSubscription()
    {
        return $this->enterpriseSubscription;
    }
    /**
     * Set enterpriseSubscription value
     * @param string $enterpriseSubscription
     * @return \StructType\RIpPhoneServices
     */
    public function setEnterpriseSubscription($enterpriseSubscription = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enterpriseSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enterpriseSubscription, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enterpriseSubscription) && !is_string($enterpriseSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enterpriseSubscription)), __LINE__);
        }
        $this->enterpriseSubscription = $enterpriseSubscription;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\Parameters|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\Parameters $parameters
     * @return \StructType\RIpPhoneServices
     */
    public function setParameters(\StructType\Parameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RIpPhoneServices
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RIpPhoneServices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
