<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RH323Line StructType
 * @subpackage Structs
 */
class RH323Line extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $asciiLabel;
    /**
     * The display
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $display;
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RDirn
     */
    public $dirn;
    /**
     * The displayAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $e164Mask;
    /**
     * The dialPlanWizardId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardId;
    /**
     * The maxNumCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta informations extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta informations extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RH323Line
     * @uses RH323Line::setIndex()
     * @uses RH323Line::setLabel()
     * @uses RH323Line::setAsciiLabel()
     * @uses RH323Line::setDisplay()
     * @uses RH323Line::setDirn()
     * @uses RH323Line::setDisplayAscii()
     * @uses RH323Line::setE164Mask()
     * @uses RH323Line::setDialPlanWizardId()
     * @uses RH323Line::setMaxNumCalls()
     * @uses RH323Line::setBusyTrigger()
     * @uses RH323Line::setCallInfoDisplay()
     * @uses RH323Line::setRecordingProfileName()
     * @uses RH323Line::setMonitoringCssName()
     * @uses RH323Line::setRecordingFlag()
     * @uses RH323Line::setAudibleMwi()
     * @uses RH323Line::setSpeedDial()
     * @uses RH323Line::setPartitionUsage()
     * @uses RH323Line::setAssociatedEndusers()
     * @uses RH323Line::setCtiid()
     * @uses RH323Line::setUuid()
     * @param string $index
     * @param string $label
     * @param string $asciiLabel
     * @param string $display
     * @param \StructType\RDirn $dirn
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $dialPlanWizardId
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \StructType\CallInfoDisplay $callInfoDisplay
     * @param \StructType\XFkType $recordingProfileName
     * @param \StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param \StructType\AssociatedEndusers $associatedEndusers
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $label = null, $asciiLabel = null, $display = null, \StructType\RDirn $dirn = null, $displayAscii = null, $e164Mask = null, $dialPlanWizardId = null, $maxNumCalls = null, $busyTrigger = null, \StructType\CallInfoDisplay $callInfoDisplay = null, \StructType\XFkType $recordingProfileName = null, \StructType\XFkType $monitoringCssName = null, $recordingFlag = null, $audibleMwi = null, $speedDial = null, $partitionUsage = null, \StructType\AssociatedEndusers $associatedEndusers = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setDisplay($display)
            ->setDirn($dirn)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setDialPlanWizardId($dialPlanWizardId)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\RH323Line
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\RH323Line
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \StructType\RH323Line
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiLabel) && strlen($asciiLabel) > 50) || (is_array($asciiLabel) && count($asciiLabel) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($asciiLabel) ? strlen($asciiLabel) : count($asciiLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiLabel) && !is_string($asciiLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiLabel)), __LINE__);
        }
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \StructType\RH323Line
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($display) && strlen($display) > 50) || (is_array($display) && count($display) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($display) ? strlen($display) : count($display)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get dirn value
     * @return \StructType\RDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \StructType\RDirn $dirn
     * @return \StructType\RH323Line
     */
    public function setDirn(\StructType\RDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \StructType\RH323Line
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($displayAscii) && strlen($displayAscii) > 50) || (is_array($displayAscii) && count($displayAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($displayAscii) ? strlen($displayAscii) : count($displayAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \StructType\RH323Line
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164Mask) && strlen($e164Mask) > 255) || (is_array($e164Mask) && count($e164Mask) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($e164Mask) ? strlen($e164Mask) : count($e164Mask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get dialPlanWizardId value
     * @return string|null
     */
    public function getDialPlanWizardId()
    {
        return $this->dialPlanWizardId;
    }
    /**
     * Set dialPlanWizardId value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardId
     * @return \StructType\RH323Line
     */
    public function setDialPlanWizardId($dialPlanWizardId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dialPlanWizardId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardId, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardId = $dialPlanWizardId;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return \StructType\RH323Line
     */
    public function setMaxNumCalls($maxNumCalls = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxNumCalls, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \StructType\RH323Line
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busyTrigger, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \StructType\CallInfoDisplay $callInfoDisplay
     * @return \StructType\RH323Line
     */
    public function setCallInfoDisplay(\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return \StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param \StructType\XFkType $recordingProfileName
     * @return \StructType\RH323Line
     */
    public function setRecordingProfileName(\StructType\XFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return \StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param \StructType\XFkType $monitoringCssName
     * @return \StructType\RH323Line
     */
    public function setMonitoringCssName(\StructType\XFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses \EnumType\XRecordingFlag::valueIsValid()
     * @uses \EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return \StructType\RH323Line
     */
    public function setRecordingFlag($recordingFlag = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingFlag, implode(', ', \EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return \StructType\RH323Line
     */
    public function setAudibleMwi($audibleMwi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audibleMwi, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * @return string|null
     */
    public function getSpeedDial()
    {
        return $this->speedDial;
    }
    /**
     * Set speedDial value
     * @param string $speedDial
     * @return \StructType\RH323Line
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($speedDial)), __LINE__);
        }
        $this->speedDial = $speedDial;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @uses \EnumType\XPartitionUsage::valueIsValid()
     * @uses \EnumType\XPartitionUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partitionUsage
     * @return \StructType\RH323Line
     */
    public function setPartitionUsage($partitionUsage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPartitionUsage::valueIsValid($partitionUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partitionUsage, implode(', ', \EnumType\XPartitionUsage::getValidValues())), __LINE__);
        }
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \StructType\AssociatedEndusers $associatedEndusers
     * @return \StructType\RH323Line
     */
    public function setAssociatedEndusers(\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\RH323Line
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RH323Line
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RH323Line
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
