<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RExtension StructType
 * @subpackage Structs
 */
class RExtension extends AbstractStructBase
{
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortOrder;
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $pattern;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * The linePrimaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $linePrimaryUri;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $partition;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RExtension
     * @uses RExtension::setSortOrder()
     * @uses RExtension::setPattern()
     * @uses RExtension::setRoutePartition()
     * @uses RExtension::setLinePrimaryUri()
     * @uses RExtension::setPartition()
     * @uses RExtension::setUuid()
     * @param string $sortOrder
     * @param \StructType\XFkType $pattern
     * @param string $routePartition
     * @param string $linePrimaryUri
     * @param \StructType\XFkType $partition
     * @param string $uuid
     */
    public function __construct($sortOrder = null, \StructType\XFkType $pattern = null, $routePartition = null, $linePrimaryUri = null, \StructType\XFkType $partition = null, $uuid = null)
    {
        $this
            ->setSortOrder($sortOrder)
            ->setPattern($pattern)
            ->setRoutePartition($routePartition)
            ->setLinePrimaryUri($linePrimaryUri)
            ->setPartition($partition)
            ->setUuid($uuid);
    }
    /**
     * Get sortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\RExtension
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortOrder, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get pattern value
     * @return \StructType\XFkType|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param \StructType\XFkType $pattern
     * @return \StructType\RExtension
     */
    public function setPattern(\StructType\XFkType $pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param string $routePartition
     * @return \StructType\RExtension
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartition)), __LINE__);
        }
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get linePrimaryUri value
     * @return string|null
     */
    public function getLinePrimaryUri()
    {
        return $this->linePrimaryUri;
    }
    /**
     * Set linePrimaryUri value
     * @param string $linePrimaryUri
     * @return \StructType\RExtension
     */
    public function setLinePrimaryUri($linePrimaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($linePrimaryUri) && !is_string($linePrimaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linePrimaryUri)), __LINE__);
        }
        $this->linePrimaryUri = $linePrimaryUri;
        return $this;
    }
    /**
     * Get partition value
     * @return \StructType\XFkType|null
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param \StructType\XFkType $partition
     * @return \StructType\RExtension
     */
    public function setPartition(\StructType\XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RExtension
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
