<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RConferenceBridge StructType
 * @subpackage Structs
 */
class RConferenceBridge extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The subUnit
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values range from 1 to 4.The value should be given as per the formula. Cisco Media Server : subunit = ((Extract two digits after 'A'
     * from the name)-2)/3 + 1. Cisco Conference Bridge: subunit = ((Extract two digits after 'C' from the name)-1)/3 + 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subUnit;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used only by Cisco Conference Bridge Hardware.For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the
     * product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used only by Cisco Video Conference Bridge(IPVC-35xx),Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The maximumCapacity
     * Meta informations extracted from the WSDL
     * - documentation: This tag is mandatory for Cisco Conference Bridge(WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco IOS Enhanced Conference Bridge
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The destinationAddress
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddress;
    /**
     * The mcuConferenceBridgeSipPort
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mcuConferenceBridgeSipPort;
    /**
     * The sipProfile
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipProfile;
    /**
     * The srtpAllowed
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The normalizationScript
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $normalizationScript;
    /**
     * The enableTrace
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTrace;
    /**
     * The normalizationScriptInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\NormalizationScriptInfos
     */
    public $normalizationScriptInfos;
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU and max length is 31
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The httpPort
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $httpPort;
    /**
     * The useHttps
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence MCU
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useHttps;
    /**
     * The addresses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Addresses
     */
    public $addresses;
    /**
     * The conferenceBridgePrefix
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $conferenceBridgePrefix;
    /**
     * The allowCFBControlOfCallSecurityIcon
     * Meta informations extracted from the WSDL
     * - documentation: This option is only available for Conference types MCU and Conductor
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCFBControlOfCallSecurityIcon;
    /**
     * The overrideSIPTrunkAddress
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $overrideSIPTrunkAddress;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RConferenceBridge
     * @uses RConferenceBridge::setName()
     * @uses RConferenceBridge::setDescription()
     * @uses RConferenceBridge::setProduct()
     * @uses RConferenceBridge::setDevicePoolName()
     * @uses RConferenceBridge::setCommonDeviceConfigName()
     * @uses RConferenceBridge::setLocationName()
     * @uses RConferenceBridge::setSubUnit()
     * @uses RConferenceBridge::setLoadInformation()
     * @uses RConferenceBridge::setVendorConfig()
     * @uses RConferenceBridge::setMaximumCapacity()
     * @uses RConferenceBridge::setUseTrustedRelayPoint()
     * @uses RConferenceBridge::setSecurityProfileName()
     * @uses RConferenceBridge::setDestinationAddress()
     * @uses RConferenceBridge::setMcuConferenceBridgeSipPort()
     * @uses RConferenceBridge::setSipProfile()
     * @uses RConferenceBridge::setSrtpAllowed()
     * @uses RConferenceBridge::setNormalizationScript()
     * @uses RConferenceBridge::setEnableTrace()
     * @uses RConferenceBridge::setNormalizationScriptInfos()
     * @uses RConferenceBridge::setUserName()
     * @uses RConferenceBridge::setPassword()
     * @uses RConferenceBridge::setHttpPort()
     * @uses RConferenceBridge::setUseHttps()
     * @uses RConferenceBridge::setAddresses()
     * @uses RConferenceBridge::setConferenceBridgePrefix()
     * @uses RConferenceBridge::setAllowCFBControlOfCallSecurityIcon()
     * @uses RConferenceBridge::setOverrideSIPTrunkAddress()
     * @uses RConferenceBridge::setSipTrunkName()
     * @uses RConferenceBridge::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param \StructType\XFkType $locationName
     * @param string $subUnit
     * @param \StructType\XLoadInformation $loadInformation
     * @param \StructType\XVendorConfig $vendorConfig
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param \StructType\XFkType $securityProfileName
     * @param string $destinationAddress
     * @param string $mcuConferenceBridgeSipPort
     * @param \StructType\XFkType $sipProfile
     * @param string $srtpAllowed
     * @param \StructType\XFkType $normalizationScript
     * @param string $enableTrace
     * @param \StructType\NormalizationScriptInfos $normalizationScriptInfos
     * @param string $userName
     * @param string $password
     * @param string $httpPort
     * @param string $useHttps
     * @param \StructType\Addresses $addresses
     * @param string $conferenceBridgePrefix
     * @param string $allowCFBControlOfCallSecurityIcon
     * @param string $overrideSIPTrunkAddress
     * @param \StructType\XFkType $sipTrunkName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, \StructType\XFkType $locationName = null, $subUnit = null, \StructType\XLoadInformation $loadInformation = null, \StructType\XVendorConfig $vendorConfig = null, $maximumCapacity = null, $useTrustedRelayPoint = null, \StructType\XFkType $securityProfileName = null, $destinationAddress = null, $mcuConferenceBridgeSipPort = null, \StructType\XFkType $sipProfile = null, $srtpAllowed = null, \StructType\XFkType $normalizationScript = null, $enableTrace = null, \StructType\NormalizationScriptInfos $normalizationScriptInfos = null, $userName = null, $password = null, $httpPort = null, $useHttps = null, \StructType\Addresses $addresses = null, $conferenceBridgePrefix = null, $allowCFBControlOfCallSecurityIcon = null, $overrideSIPTrunkAddress = null, \StructType\XFkType $sipTrunkName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setSubUnit($subUnit)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName)
            ->setDestinationAddress($destinationAddress)
            ->setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort)
            ->setSipProfile($sipProfile)
            ->setSrtpAllowed($srtpAllowed)
            ->setNormalizationScript($normalizationScript)
            ->setEnableTrace($enableTrace)
            ->setNormalizationScriptInfos($normalizationScriptInfos)
            ->setUserName($userName)
            ->setPassword($password)
            ->setHttpPort($httpPort)
            ->setUseHttps($useHttps)
            ->setAddresses($addresses)
            ->setConferenceBridgePrefix($conferenceBridgePrefix)
            ->setAllowCFBControlOfCallSecurityIcon($allowCFBControlOfCallSecurityIcon)
            ->setOverrideSIPTrunkAddress($overrideSIPTrunkAddress)
            ->setSipTrunkName($sipTrunkName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RConferenceBridge
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RConferenceBridge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\RConferenceBridge
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\RConferenceBridge
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\RConferenceBridge
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\RConferenceBridge
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subUnit
     * @return \StructType\RConferenceBridge
     */
    public function setSubUnit($subUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($subUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subUnit, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \StructType\XLoadInformation $loadInformation
     * @return \StructType\RConferenceBridge
     */
    public function setLoadInformation(\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \StructType\XVendorConfig $vendorConfig
     * @return \StructType\RConferenceBridge
     */
    public function setVendorConfig(\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maximumCapacity
     * @return \StructType\RConferenceBridge
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maximumCapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maximumCapacity, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\RConferenceBridge
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \StructType\XFkType $securityProfileName
     * @return \StructType\RConferenceBridge
     */
    public function setSecurityProfileName(\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \StructType\RConferenceBridge
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get mcuConferenceBridgeSipPort value
     * @return string|null
     */
    public function getMcuConferenceBridgeSipPort()
    {
        return $this->mcuConferenceBridgeSipPort;
    }
    /**
     * Set mcuConferenceBridgeSipPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mcuConferenceBridgeSipPort
     * @return \StructType\RConferenceBridge
     */
    public function setMcuConferenceBridgeSipPort($mcuConferenceBridgeSipPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($mcuConferenceBridgeSipPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mcuConferenceBridgeSipPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mcuConferenceBridgeSipPort = $mcuConferenceBridgeSipPort;
        return $this;
    }
    /**
     * Get sipProfile value
     * @return \StructType\XFkType|null
     */
    public function getSipProfile()
    {
        return $this->sipProfile;
    }
    /**
     * Set sipProfile value
     * @param \StructType\XFkType $sipProfile
     * @return \StructType\RConferenceBridge
     */
    public function setSipProfile(\StructType\XFkType $sipProfile = null)
    {
        $this->sipProfile = $sipProfile;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \StructType\RConferenceBridge
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpAllowed)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get normalizationScript value
     * @return \StructType\XFkType|null
     */
    public function getNormalizationScript()
    {
        return $this->normalizationScript;
    }
    /**
     * Set normalizationScript value
     * @param \StructType\XFkType $normalizationScript
     * @return \StructType\RConferenceBridge
     */
    public function setNormalizationScript(\StructType\XFkType $normalizationScript = null)
    {
        $this->normalizationScript = $normalizationScript;
        return $this;
    }
    /**
     * Get enableTrace value
     * @return string|null
     */
    public function getEnableTrace()
    {
        return $this->enableTrace;
    }
    /**
     * Set enableTrace value
     * @param string $enableTrace
     * @return \StructType\RConferenceBridge
     */
    public function setEnableTrace($enableTrace = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableTrace) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableTrace, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableTrace) && !is_string($enableTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableTrace)), __LINE__);
        }
        $this->enableTrace = $enableTrace;
        return $this;
    }
    /**
     * Get normalizationScriptInfos value
     * @return \StructType\NormalizationScriptInfos|null
     */
    public function getNormalizationScriptInfos()
    {
        return $this->normalizationScriptInfos;
    }
    /**
     * Set normalizationScriptInfos value
     * @param \StructType\NormalizationScriptInfos $normalizationScriptInfos
     * @return \StructType\RConferenceBridge
     */
    public function setNormalizationScriptInfos(\StructType\NormalizationScriptInfos $normalizationScriptInfos = null)
    {
        $this->normalizationScriptInfos = $normalizationScriptInfos;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\RConferenceBridge
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\RConferenceBridge
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get httpPort value
     * @return string|null
     */
    public function getHttpPort()
    {
        return $this->httpPort;
    }
    /**
     * Set httpPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $httpPort
     * @return \StructType\RConferenceBridge
     */
    public function setHttpPort($httpPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($httpPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $httpPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->httpPort = $httpPort;
        return $this;
    }
    /**
     * Get useHttps value
     * @return string|null
     */
    public function getUseHttps()
    {
        return $this->useHttps;
    }
    /**
     * Set useHttps value
     * @param string $useHttps
     * @return \StructType\RConferenceBridge
     */
    public function setUseHttps($useHttps = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useHttps) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useHttps, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useHttps) && !is_string($useHttps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useHttps)), __LINE__);
        }
        $this->useHttps = $useHttps;
        return $this;
    }
    /**
     * Get addresses value
     * @return \StructType\Addresses|null
     */
    public function getAddresses()
    {
        return $this->addresses;
    }
    /**
     * Set addresses value
     * @param \StructType\Addresses $addresses
     * @return \StructType\RConferenceBridge
     */
    public function setAddresses(\StructType\Addresses $addresses = null)
    {
        $this->addresses = $addresses;
        return $this;
    }
    /**
     * Get conferenceBridgePrefix value
     * @return string|null
     */
    public function getConferenceBridgePrefix()
    {
        return $this->conferenceBridgePrefix;
    }
    /**
     * Set conferenceBridgePrefix value
     * @param string $conferenceBridgePrefix
     * @return \StructType\RConferenceBridge
     */
    public function setConferenceBridgePrefix($conferenceBridgePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($conferenceBridgePrefix) && !is_string($conferenceBridgePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conferenceBridgePrefix)), __LINE__);
        }
        $this->conferenceBridgePrefix = $conferenceBridgePrefix;
        return $this;
    }
    /**
     * Get allowCFBControlOfCallSecurityIcon value
     * @return string|null
     */
    public function getAllowCFBControlOfCallSecurityIcon()
    {
        return $this->allowCFBControlOfCallSecurityIcon;
    }
    /**
     * Set allowCFBControlOfCallSecurityIcon value
     * @param string $allowCFBControlOfCallSecurityIcon
     * @return \StructType\RConferenceBridge
     */
    public function setAllowCFBControlOfCallSecurityIcon($allowCFBControlOfCallSecurityIcon = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowCFBControlOfCallSecurityIcon) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCFBControlOfCallSecurityIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowCFBControlOfCallSecurityIcon, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowCFBControlOfCallSecurityIcon) && !is_string($allowCFBControlOfCallSecurityIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowCFBControlOfCallSecurityIcon)), __LINE__);
        }
        $this->allowCFBControlOfCallSecurityIcon = $allowCFBControlOfCallSecurityIcon;
        return $this;
    }
    /**
     * Get overrideSIPTrunkAddress value
     * @return string|null
     */
    public function getOverrideSIPTrunkAddress()
    {
        return $this->overrideSIPTrunkAddress;
    }
    /**
     * Set overrideSIPTrunkAddress value
     * @param string $overrideSIPTrunkAddress
     * @return \StructType\RConferenceBridge
     */
    public function setOverrideSIPTrunkAddress($overrideSIPTrunkAddress = null)
    {
        // validation for constraint: pattern
        if (is_scalar($overrideSIPTrunkAddress) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($overrideSIPTrunkAddress, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($overrideSIPTrunkAddress) && !is_string($overrideSIPTrunkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideSIPTrunkAddress)), __LINE__);
        }
        $this->overrideSIPTrunkAddress = $overrideSIPTrunkAddress;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\RConferenceBridge
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RConferenceBridge
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RConferenceBridge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
