<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCalledPartyTracing StructType
 * @subpackage Structs
 */
class RCalledPartyTracing extends AbstractStructBase
{
    /**
     * The directorynumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directorynumber;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCalledPartyTracing
     * @uses RCalledPartyTracing::setDirectorynumber()
     * @uses RCalledPartyTracing::setDescription()
     * @uses RCalledPartyTracing::setUuid()
     * @param string $directorynumber
     * @param string $description
     * @param string $uuid
     */
    public function __construct($directorynumber = null, $description = null, $uuid = null)
    {
        $this
            ->setDirectorynumber($directorynumber)
            ->setDescription($description)
            ->setUuid($uuid);
    }
    /**
     * Get directorynumber value
     * @return string|null
     */
    public function getDirectorynumber()
    {
        return $this->directorynumber;
    }
    /**
     * Set directorynumber value
     * @param string $directorynumber
     * @return \StructType\RCalledPartyTracing
     */
    public function setDirectorynumber($directorynumber = null)
    {
        // validation for constraint: string
        if (!is_null($directorynumber) && !is_string($directorynumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directorynumber)), __LINE__);
        }
        $this->directorynumber = $directorynumber;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RCalledPartyTracing
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RCalledPartyTracing
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RCalledPartyTracing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
