<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXSipProfile StructType
 * @subpackage Structs
 */
class OXSipProfile extends AbstractStructBase
{
    /**
     * The userInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $telnetLevel;
    /**
     * The rerouteIncomingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The rsvpOverSip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $rsvpOverSip;
    /**
     * The sipRe11XxEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $gClear;
    /**
     * The sipBandwidthModifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $sipBandwidthModifier;
    /**
     * The userAgentServerHeaderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $userAgentServerHeaderInfo;
    /**
     * The sipNormalizationScript
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $sipNormalizationScript;
    /**
     * The dialStringInterpretation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $acceptAudioCodecPreferences;
    /**
     * The resourcePriorityNamespace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The callingLineIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callingLineIdentification;
    /**
     * The videoCallTrafficClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta informations extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $sdpTransparency;
    /**
     * The sipSessionRefreshMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXSipProfile
     * @uses OXSipProfile::setUserInfo()
     * @uses OXSipProfile::setDtmfDbLevel()
     * @uses OXSipProfile::setCallHoldRingback()
     * @uses OXSipProfile::setAnonymousCallBlock()
     * @uses OXSipProfile::setCallerIdBlock()
     * @uses OXSipProfile::setDndControl()
     * @uses OXSipProfile::setTelnetLevel()
     * @uses OXSipProfile::setRerouteIncomingRequest()
     * @uses OXSipProfile::setResourcePriorityNamespaceListName()
     * @uses OXSipProfile::setRsvpOverSip()
     * @uses OXSipProfile::setSipRe11XxEnabled()
     * @uses OXSipProfile::setGClear()
     * @uses OXSipProfile::setSipBandwidthModifier()
     * @uses OXSipProfile::setUserAgentServerHeaderInfo()
     * @uses OXSipProfile::setSipNormalizationScript()
     * @uses OXSipProfile::setDialStringInterpretation()
     * @uses OXSipProfile::setAcceptAudioCodecPreferences()
     * @uses OXSipProfile::setResourcePriorityNamespace()
     * @uses OXSipProfile::setCallingLineIdentification()
     * @uses OXSipProfile::setVideoCallTrafficClass()
     * @uses OXSipProfile::setSdpTransparency()
     * @uses OXSipProfile::setSipSessionRefreshMethod()
     * @uses OXSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses OXSipProfile::setCucmVersionInSipHeader()
     * @uses OXSipProfile::setConfidentialAccessLevelHeaders()
     * @uses OXSipProfile::setUuid()
     * @param \StructType\OXFkType $userInfo
     * @param \StructType\OXFkType $dtmfDbLevel
     * @param \StructType\OXFkType $callHoldRingback
     * @param \StructType\OXFkType $anonymousCallBlock
     * @param \StructType\OXFkType $callerIdBlock
     * @param \StructType\OXFkType $dndControl
     * @param \StructType\OXFkType $telnetLevel
     * @param \StructType\OXFkType $rerouteIncomingRequest
     * @param \StructType\OXFkType $resourcePriorityNamespaceListName
     * @param \StructType\OXFkType $rsvpOverSip
     * @param \StructType\OXFkType $sipRe11XxEnabled
     * @param \StructType\OXFkType $gClear
     * @param \StructType\OXFkType $sipBandwidthModifier
     * @param \StructType\OXFkType $userAgentServerHeaderInfo
     * @param \StructType\OXFkType $sipNormalizationScript
     * @param \StructType\OXFkType $dialStringInterpretation
     * @param \StructType\OXFkType $acceptAudioCodecPreferences
     * @param \StructType\OXFkType $resourcePriorityNamespace
     * @param \StructType\OXFkType $callingLineIdentification
     * @param \StructType\OXFkType $videoCallTrafficClass
     * @param \StructType\OXFkType $sdpTransparency
     * @param \StructType\OXFkType $sipSessionRefreshMethod
     * @param \StructType\OXFkType $earlyOfferSuppVoiceCall
     * @param \StructType\OXFkType $cucmVersionInSipHeader
     * @param \StructType\OXFkType $confidentialAccessLevelHeaders
     * @param string $uuid
     */
    public function __construct(\StructType\OXFkType $userInfo = null, \StructType\OXFkType $dtmfDbLevel = null, \StructType\OXFkType $callHoldRingback = null, \StructType\OXFkType $anonymousCallBlock = null, \StructType\OXFkType $callerIdBlock = null, \StructType\OXFkType $dndControl = null, \StructType\OXFkType $telnetLevel = null, \StructType\OXFkType $rerouteIncomingRequest = null, \StructType\OXFkType $resourcePriorityNamespaceListName = null, \StructType\OXFkType $rsvpOverSip = null, \StructType\OXFkType $sipRe11XxEnabled = null, \StructType\OXFkType $gClear = null, \StructType\OXFkType $sipBandwidthModifier = null, \StructType\OXFkType $userAgentServerHeaderInfo = null, \StructType\OXFkType $sipNormalizationScript = null, \StructType\OXFkType $dialStringInterpretation = null, \StructType\OXFkType $acceptAudioCodecPreferences = null, \StructType\OXFkType $resourcePriorityNamespace = null, \StructType\OXFkType $callingLineIdentification = null, \StructType\OXFkType $videoCallTrafficClass = null, \StructType\OXFkType $sdpTransparency = null, \StructType\OXFkType $sipSessionRefreshMethod = null, \StructType\OXFkType $earlyOfferSuppVoiceCall = null, \StructType\OXFkType $cucmVersionInSipHeader = null, \StructType\OXFkType $confidentialAccessLevelHeaders = null, $uuid = null)
    {
        $this
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setRsvpOverSip($rsvpOverSip)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setUuid($uuid);
    }
    /**
     * Get userInfo value
     * @return \StructType\OXFkType|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param \StructType\OXFkType $userInfo
     * @return \StructType\OXSipProfile
     */
    public function setUserInfo(\StructType\OXFkType $userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return \StructType\OXFkType|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @param \StructType\OXFkType $dtmfDbLevel
     * @return \StructType\OXSipProfile
     */
    public function setDtmfDbLevel(\StructType\OXFkType $dtmfDbLevel = null)
    {
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return \StructType\OXFkType|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @param \StructType\OXFkType $callHoldRingback
     * @return \StructType\OXSipProfile
     */
    public function setCallHoldRingback(\StructType\OXFkType $callHoldRingback = null)
    {
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return \StructType\OXFkType|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @param \StructType\OXFkType $anonymousCallBlock
     * @return \StructType\OXSipProfile
     */
    public function setAnonymousCallBlock(\StructType\OXFkType $anonymousCallBlock = null)
    {
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return \StructType\OXFkType|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @param \StructType\OXFkType $callerIdBlock
     * @return \StructType\OXSipProfile
     */
    public function setCallerIdBlock(\StructType\OXFkType $callerIdBlock = null)
    {
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return \StructType\OXFkType|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @param \StructType\OXFkType $dndControl
     * @return \StructType\OXSipProfile
     */
    public function setDndControl(\StructType\OXFkType $dndControl = null)
    {
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return \StructType\OXFkType|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @param \StructType\OXFkType $telnetLevel
     * @return \StructType\OXSipProfile
     */
    public function setTelnetLevel(\StructType\OXFkType $telnetLevel = null)
    {
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return \StructType\OXFkType|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @param \StructType\OXFkType $rerouteIncomingRequest
     * @return \StructType\OXSipProfile
     */
    public function setRerouteIncomingRequest(\StructType\OXFkType $rerouteIncomingRequest = null)
    {
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return \StructType\OXFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param \StructType\OXFkType $resourcePriorityNamespaceListName
     * @return \StructType\OXSipProfile
     */
    public function setResourcePriorityNamespaceListName(\StructType\OXFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return \StructType\OXFkType|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @param \StructType\OXFkType $rsvpOverSip
     * @return \StructType\OXSipProfile
     */
    public function setRsvpOverSip(\StructType\OXFkType $rsvpOverSip = null)
    {
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return \StructType\OXFkType|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @param \StructType\OXFkType $sipRe11XxEnabled
     * @return \StructType\OXSipProfile
     */
    public function setSipRe11XxEnabled(\StructType\OXFkType $sipRe11XxEnabled = null)
    {
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return \StructType\OXFkType|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @param \StructType\OXFkType $gClear
     * @return \StructType\OXSipProfile
     */
    public function setGClear(\StructType\OXFkType $gClear = null)
    {
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return \StructType\OXFkType|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @param \StructType\OXFkType $sipBandwidthModifier
     * @return \StructType\OXSipProfile
     */
    public function setSipBandwidthModifier(\StructType\OXFkType $sipBandwidthModifier = null)
    {
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return \StructType\OXFkType|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @param \StructType\OXFkType $userAgentServerHeaderInfo
     * @return \StructType\OXSipProfile
     */
    public function setUserAgentServerHeaderInfo(\StructType\OXFkType $userAgentServerHeaderInfo = null)
    {
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return \StructType\OXFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param \StructType\OXFkType $sipNormalizationScript
     * @return \StructType\OXSipProfile
     */
    public function setSipNormalizationScript(\StructType\OXFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return \StructType\OXFkType|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @param \StructType\OXFkType $dialStringInterpretation
     * @return \StructType\OXSipProfile
     */
    public function setDialStringInterpretation(\StructType\OXFkType $dialStringInterpretation = null)
    {
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return \StructType\OXFkType|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @param \StructType\OXFkType $acceptAudioCodecPreferences
     * @return \StructType\OXSipProfile
     */
    public function setAcceptAudioCodecPreferences(\StructType\OXFkType $acceptAudioCodecPreferences = null)
    {
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return \StructType\OXFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param \StructType\OXFkType $resourcePriorityNamespace
     * @return \StructType\OXSipProfile
     */
    public function setResourcePriorityNamespace(\StructType\OXFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return \StructType\OXFkType|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @param \StructType\OXFkType $callingLineIdentification
     * @return \StructType\OXSipProfile
     */
    public function setCallingLineIdentification(\StructType\OXFkType $callingLineIdentification = null)
    {
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return \StructType\OXFkType|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @param \StructType\OXFkType $videoCallTrafficClass
     * @return \StructType\OXSipProfile
     */
    public function setVideoCallTrafficClass(\StructType\OXFkType $videoCallTrafficClass = null)
    {
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return \StructType\OXFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param \StructType\OXFkType $sdpTransparency
     * @return \StructType\OXSipProfile
     */
    public function setSdpTransparency(\StructType\OXFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return \StructType\OXFkType|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @param \StructType\OXFkType $sipSessionRefreshMethod
     * @return \StructType\OXSipProfile
     */
    public function setSipSessionRefreshMethod(\StructType\OXFkType $sipSessionRefreshMethod = null)
    {
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return \StructType\OXFkType|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @param \StructType\OXFkType $earlyOfferSuppVoiceCall
     * @return \StructType\OXSipProfile
     */
    public function setEarlyOfferSuppVoiceCall(\StructType\OXFkType $earlyOfferSuppVoiceCall = null)
    {
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return \StructType\OXFkType|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @param \StructType\OXFkType $cucmVersionInSipHeader
     * @return \StructType\OXSipProfile
     */
    public function setCucmVersionInSipHeader(\StructType\OXFkType $cucmVersionInSipHeader = null)
    {
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return \StructType\OXFkType|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @param \StructType\OXFkType $confidentialAccessLevelHeaders
     * @return \StructType\OXSipProfile
     */
    public function setConfidentialAccessLevelHeaders(\StructType\OXFkType $confidentialAccessLevelHeaders = null)
    {
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OXSipProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
