<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXFkTypeProduct StructType
 * @subpackage Structs
 */
class OXFkTypeProduct extends OXFkType
{
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * Constructor method for OXFkTypeProduct
     * @uses OXFkTypeProduct::setProduct()
     * @param string $product
     */
    public function __construct($product = null)
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\OXFkTypeProduct
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OXFkTypeProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
