<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXDeviceProfile StructType
 * @subpackage Structs
 */
class OXDeviceProfile extends AbstractStructBase
{
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $protocolSide;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $preemption;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Lines
     */
    public $lines;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkTypeProduct_Protocol
     */
    public $phoneTemplateName;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $loginUserId;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $dndRingSetting;
    /**
     * The emccCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callInfoPrivacyStatus;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXDeviceProfile
     * @uses OXDeviceProfile::setProduct()
     * @uses OXDeviceProfile::setClass()
     * @uses OXDeviceProfile::setProtocol()
     * @uses OXDeviceProfile::setProtocolSide()
     * @uses OXDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses OXDeviceProfile::setMlppIndicationStatus()
     * @uses OXDeviceProfile::setPreemption()
     * @uses OXDeviceProfile::setLines()
     * @uses OXDeviceProfile::setPhoneTemplateName()
     * @uses OXDeviceProfile::setBlfDirectedCallParks()
     * @uses OXDeviceProfile::setAddOnModules()
     * @uses OXDeviceProfile::setUserLocale()
     * @uses OXDeviceProfile::setSingleButtonBarge()
     * @uses OXDeviceProfile::setJoinAcrossLines()
     * @uses OXDeviceProfile::setLoginUserId()
     * @uses OXDeviceProfile::setDndOption()
     * @uses OXDeviceProfile::setDndRingSetting()
     * @uses OXDeviceProfile::setEmccCallingSearchSpace()
     * @uses OXDeviceProfile::setAlwaysUsePrimeLine()
     * @uses OXDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses OXDeviceProfile::setSoftkeyTemplateName()
     * @uses OXDeviceProfile::setCallInfoPrivacyStatus()
     * @uses OXDeviceProfile::setServices()
     * @uses OXDeviceProfile::setFeatureControlPolicy()
     * @uses OXDeviceProfile::setCtiid()
     * @uses OXDeviceProfile::setUuid()
     * @param \StructType\OXFkType $product
     * @param \StructType\OXFkType $class
     * @param \StructType\OXFkTypeProduct $protocol
     * @param \StructType\OXFkType $protocolSide
     * @param \StructType\OXFkType $userHoldMohAudioSourceId
     * @param \StructType\OXFkType $mlppIndicationStatus
     * @param \StructType\OXFkType $preemption
     * @param \StructType\Lines $lines
     * @param \StructType\OXFkTypeProduct_Protocol $phoneTemplateName
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \StructType\AddOnModules $addOnModules
     * @param \StructType\OXFkType $userLocale
     * @param \StructType\OXFkType $singleButtonBarge
     * @param \StructType\OXFkType $joinAcrossLines
     * @param \StructType\OXFkType $loginUserId
     * @param \StructType\OXFkType $dndOption
     * @param \StructType\OXFkType $dndRingSetting
     * @param \StructType\OXFkType $emccCallingSearchSpace
     * @param \StructType\OXFkType $alwaysUsePrimeLine
     * @param \StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @param \StructType\OXFkType $softkeyTemplateName
     * @param \StructType\OXFkType $callInfoPrivacyStatus
     * @param \StructType\Services $services
     * @param \StructType\OXFkType $featureControlPolicy
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\StructType\OXFkType $product = null, \StructType\OXFkType $class = null, \StructType\OXFkTypeProduct $protocol = null, \StructType\OXFkType $protocolSide = null, \StructType\OXFkType $userHoldMohAudioSourceId = null, \StructType\OXFkType $mlppIndicationStatus = null, \StructType\OXFkType $preemption = null, \StructType\Lines $lines = null, \StructType\OXFkTypeProduct_Protocol $phoneTemplateName = null, \StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \StructType\AddOnModules $addOnModules = null, \StructType\OXFkType $userLocale = null, \StructType\OXFkType $singleButtonBarge = null, \StructType\OXFkType $joinAcrossLines = null, \StructType\OXFkType $loginUserId = null, \StructType\OXFkType $dndOption = null, \StructType\OXFkType $dndRingSetting = null, \StructType\OXFkType $emccCallingSearchSpace = null, \StructType\OXFkType $alwaysUsePrimeLine = null, \StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null, \StructType\OXFkType $softkeyTemplateName = null, \StructType\OXFkType $callInfoPrivacyStatus = null, \StructType\Services $services = null, \StructType\OXFkType $featureControlPolicy = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setLines($lines)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setServices($services)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get product value
     * @return \StructType\OXFkType|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\OXFkType $product
     * @return \StructType\OXDeviceProfile
     */
    public function setProduct(\StructType\OXFkType $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\OXFkType|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\OXFkType $class
     * @return \StructType\OXDeviceProfile
     */
    public function setClass(\StructType\OXFkType $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return \StructType\OXFkTypeProduct|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param \StructType\OXFkTypeProduct $protocol
     * @return \StructType\OXDeviceProfile
     */
    public function setProtocol(\StructType\OXFkTypeProduct $protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return \StructType\OXFkType|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param \StructType\OXFkType $protocolSide
     * @return \StructType\OXDeviceProfile
     */
    public function setProtocolSide(\StructType\OXFkType $protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return \StructType\OXFkType|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @param \StructType\OXFkType $userHoldMohAudioSourceId
     * @return \StructType\OXDeviceProfile
     */
    public function setUserHoldMohAudioSourceId(\StructType\OXFkType $userHoldMohAudioSourceId = null)
    {
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return \StructType\OXFkType|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param \StructType\OXFkType $mlppIndicationStatus
     * @return \StructType\OXDeviceProfile
     */
    public function setMlppIndicationStatus(\StructType\OXFkType $mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return \StructType\OXFkType|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param \StructType\OXFkType $preemption
     * @return \StructType\OXDeviceProfile
     */
    public function setPreemption(\StructType\OXFkType $preemption = null)
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \StructType\Lines $lines
     * @return \StructType\OXDeviceProfile
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \StructType\OXFkTypeProduct_Protocol|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \StructType\OXFkTypeProduct_Protocol $phoneTemplateName
     * @return \StructType\OXDeviceProfile
     */
    public function setPhoneTemplateName(\StructType\OXFkTypeProduct_Protocol $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \StructType\OXDeviceProfile
     */
    public function setBlfDirectedCallParks(\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \StructType\AddOnModules $addOnModules
     * @return \StructType\OXDeviceProfile
     */
    public function setAddOnModules(\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * @return \StructType\OXFkType|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @param \StructType\OXFkType $userLocale
     * @return \StructType\OXDeviceProfile
     */
    public function setUserLocale(\StructType\OXFkType $userLocale = null)
    {
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return \StructType\OXFkType|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param \StructType\OXFkType $singleButtonBarge
     * @return \StructType\OXDeviceProfile
     */
    public function setSingleButtonBarge(\StructType\OXFkType $singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return \StructType\OXFkType|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param \StructType\OXFkType $joinAcrossLines
     * @return \StructType\OXDeviceProfile
     */
    public function setJoinAcrossLines(\StructType\OXFkType $joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return \StructType\OXFkType|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param \StructType\OXFkType $loginUserId
     * @return \StructType\OXDeviceProfile
     */
    public function setLoginUserId(\StructType\OXFkType $loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get dndOption value
     * @return \StructType\OXFkType|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param \StructType\OXFkType $dndOption
     * @return \StructType\OXDeviceProfile
     */
    public function setDndOption(\StructType\OXFkType $dndOption = null)
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return \StructType\OXFkType|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @param \StructType\OXFkType $dndRingSetting
     * @return \StructType\OXDeviceProfile
     */
    public function setDndRingSetting(\StructType\OXFkType $dndRingSetting = null)
    {
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * @return \StructType\OXFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return $this->emccCallingSearchSpace;
    }
    /**
     * Set emccCallingSearchSpace value
     * @param \StructType\OXFkType $emccCallingSearchSpace
     * @return \StructType\OXDeviceProfile
     */
    public function setEmccCallingSearchSpace(\StructType\OXFkType $emccCallingSearchSpace = null)
    {
        $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return \StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param \StructType\OXFkType $alwaysUsePrimeLine
     * @return \StructType\OXDeviceProfile
     */
    public function setAlwaysUsePrimeLine(\StructType\OXFkType $alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return \StructType\OXFkType|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param \StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage
     * @return \StructType\OXDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage(\StructType\OXFkType $alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \StructType\OXFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \StructType\OXFkType $softkeyTemplateName
     * @return \StructType\OXDeviceProfile
     */
    public function setSoftkeyTemplateName(\StructType\OXFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return \StructType\OXFkType|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param \StructType\OXFkType $callInfoPrivacyStatus
     * @return \StructType\OXDeviceProfile
     */
    public function setCallInfoPrivacyStatus(\StructType\OXFkType $callInfoPrivacyStatus = null)
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\OXDeviceProfile
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \StructType\OXFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \StructType\OXFkType $featureControlPolicy
     * @return \StructType\OXDeviceProfile
     */
    public function setFeatureControlPolicy(\StructType\OXFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\OXDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXDeviceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OXDeviceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
