<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewIlsConfig StructType
 * @subpackage Structs
 */
class NewIlsConfig extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clusterId;
    /**
     * The lastContactTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastContactTime;
    /**
     * The clusterUriString
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $clusterUriString;
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $role;
    /**
     * The lastDataRecieved
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastDataRecieved;
    /**
     * The syncronizationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $syncronizationStatus;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for NewIlsConfig
     * @uses NewIlsConfig::setClusterId()
     * @uses NewIlsConfig::setLastContactTime()
     * @uses NewIlsConfig::setClusterUriString()
     * @uses NewIlsConfig::setRole()
     * @uses NewIlsConfig::setLastDataRecieved()
     * @uses NewIlsConfig::setSyncronizationStatus()
     * @uses NewIlsConfig::setUuid()
     * @param string $clusterId
     * @param string $lastContactTime
     * @param string $clusterUriString
     * @param string $role
     * @param string $lastDataRecieved
     * @param string $syncronizationStatus
     * @param string $uuid
     */
    public function __construct($clusterId = null, $lastContactTime = null, $clusterUriString = null, $role = null, $lastDataRecieved = null, $syncronizationStatus = null, $uuid = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setLastContactTime($lastContactTime)
            ->setClusterUriString($clusterUriString)
            ->setRole($role)
            ->setLastDataRecieved($lastDataRecieved)
            ->setSyncronizationStatus($syncronizationStatus)
            ->setUuid($uuid);
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\NewIlsConfig
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get lastContactTime value
     * @return string|null
     */
    public function getLastContactTime()
    {
        return $this->lastContactTime;
    }
    /**
     * Set lastContactTime value
     * @param string $lastContactTime
     * @return \StructType\NewIlsConfig
     */
    public function setLastContactTime($lastContactTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastContactTime) && !is_string($lastContactTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastContactTime)), __LINE__);
        }
        $this->lastContactTime = $lastContactTime;
        return $this;
    }
    /**
     * Get clusterUriString value
     * @return string|null
     */
    public function getClusterUriString()
    {
        return $this->clusterUriString;
    }
    /**
     * Set clusterUriString value
     * @param string $clusterUriString
     * @return \StructType\NewIlsConfig
     */
    public function setClusterUriString($clusterUriString = null)
    {
        // validation for constraint: string
        if (!is_null($clusterUriString) && !is_string($clusterUriString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterUriString)), __LINE__);
        }
        $this->clusterUriString = $clusterUriString;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\NewIlsConfig
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get lastDataRecieved value
     * @return string|null
     */
    public function getLastDataRecieved()
    {
        return $this->lastDataRecieved;
    }
    /**
     * Set lastDataRecieved value
     * @param string $lastDataRecieved
     * @return \StructType\NewIlsConfig
     */
    public function setLastDataRecieved($lastDataRecieved = null)
    {
        // validation for constraint: string
        if (!is_null($lastDataRecieved) && !is_string($lastDataRecieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDataRecieved)), __LINE__);
        }
        $this->lastDataRecieved = $lastDataRecieved;
        return $this;
    }
    /**
     * Get syncronizationStatus value
     * @return string|null
     */
    public function getSyncronizationStatus()
    {
        return $this->syncronizationStatus;
    }
    /**
     * Set syncronizationStatus value
     * @param string $syncronizationStatus
     * @return \StructType\NewIlsConfig
     */
    public function setSyncronizationStatus($syncronizationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($syncronizationStatus) && !is_string($syncronizationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syncronizationStatus)), __LINE__);
        }
        $this->syncronizationStatus = $syncronizationStatus;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\NewIlsConfig
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewIlsConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
