<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSyslogConfig StructType
 * @subpackage Structs
 */
class LSyslogConfig extends AbstractStructBase
{
    /**
     * The AlarmLevelEvent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmLevelEvent;
    /**
     * The RemoteServerName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RemoteServerName;
    /**
     * The monitor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $monitor;
    /**
     * The Enable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $Enable;
    /**
     * Constructor method for LSyslogConfig
     * @uses LSyslogConfig::setAlarmLevelEvent()
     * @uses LSyslogConfig::setRemoteServerName()
     * @uses LSyslogConfig::setMonitor()
     * @uses LSyslogConfig::setEnable()
     * @param string $alarmLevelEvent
     * @param string $remoteServerName
     * @param string $monitor
     * @param string $enable
     */
    public function __construct($alarmLevelEvent = null, $remoteServerName = null, $monitor = null, $enable = null)
    {
        $this
            ->setAlarmLevelEvent($alarmLevelEvent)
            ->setRemoteServerName($remoteServerName)
            ->setMonitor($monitor)
            ->setEnable($enable);
    }
    /**
     * Get AlarmLevelEvent value
     * @return string|null
     */
    public function getAlarmLevelEvent()
    {
        return $this->AlarmLevelEvent;
    }
    /**
     * Set AlarmLevelEvent value
     * @uses \EnumType\XAlarmSeverity::valueIsValid()
     * @uses \EnumType\XAlarmSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmLevelEvent
     * @return \StructType\LSyslogConfig
     */
    public function setAlarmLevelEvent($alarmLevelEvent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAlarmSeverity::valueIsValid($alarmLevelEvent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alarmLevelEvent, implode(', ', \EnumType\XAlarmSeverity::getValidValues())), __LINE__);
        }
        $this->AlarmLevelEvent = $alarmLevelEvent;
        return $this;
    }
    /**
     * Get RemoteServerName value
     * @return string|null
     */
    public function getRemoteServerName()
    {
        return $this->RemoteServerName;
    }
    /**
     * Set RemoteServerName value
     * @param string $remoteServerName
     * @return \StructType\LSyslogConfig
     */
    public function setRemoteServerName($remoteServerName = null)
    {
        // validation for constraint: string
        if (!is_null($remoteServerName) && !is_string($remoteServerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteServerName)), __LINE__);
        }
        $this->RemoteServerName = $remoteServerName;
        return $this;
    }
    /**
     * Get monitor value
     * @return string|null
     */
    public function getMonitor()
    {
        return $this->monitor;
    }
    /**
     * Set monitor value
     * @param string $monitor
     * @return \StructType\LSyslogConfig
     */
    public function setMonitor($monitor = null)
    {
        // validation for constraint: string
        if (!is_null($monitor) && !is_string($monitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monitor)), __LINE__);
        }
        $this->monitor = $monitor;
        return $this;
    }
    /**
     * Get Enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->Enable;
    }
    /**
     * Set Enable value
     * @param string $enable
     * @return \StructType\LSyslogConfig
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->Enable = $enable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LSyslogConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
