<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteList StructType
 * @subpackage Structs
 */
class LRouteList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The routeListEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeListEnabled;
    /**
     * The runOnEveryNode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteList
     * @uses LRouteList::setName()
     * @uses LRouteList::setDescription()
     * @uses LRouteList::setCallManagerGroupName()
     * @uses LRouteList::setRouteListEnabled()
     * @uses LRouteList::setRunOnEveryNode()
     * @uses LRouteList::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $callManagerGroupName
     * @param string $routeListEnabled
     * @param string $runOnEveryNode
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $callManagerGroupName = null, $routeListEnabled = null, $runOnEveryNode = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setRouteListEnabled($routeListEnabled)
            ->setRunOnEveryNode($runOnEveryNode)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LRouteList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LRouteList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\LRouteList
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get routeListEnabled value
     * @return string|null
     */
    public function getRouteListEnabled()
    {
        return $this->routeListEnabled;
    }
    /**
     * Set routeListEnabled value
     * @param string $routeListEnabled
     * @return \StructType\LRouteList
     */
    public function setRouteListEnabled($routeListEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($routeListEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($routeListEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeListEnabled) && !is_string($routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeListEnabled)), __LINE__);
        }
        $this->routeListEnabled = $routeListEnabled;
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return \StructType\LRouteList
     */
    public function setRunOnEveryNode($runOnEveryNode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($runOnEveryNode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($runOnEveryNode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runOnEveryNode) && !is_string($runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runOnEveryNode)), __LINE__);
        }
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LRouteList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LRouteList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
