<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRouteGroupMember StructType
 * @subpackage Structs
 */
class LRouteGroupMember extends AbstractStructBase
{
    /**
     * The deviceSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSelectionOrder;
    /**
     * The dialPlanWizardGenId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardGenId;
    /**
     * The deviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $deviceName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRouteGroupMember
     * @uses LRouteGroupMember::setDeviceSelectionOrder()
     * @uses LRouteGroupMember::setDialPlanWizardGenId()
     * @uses LRouteGroupMember::setDeviceName()
     * @uses LRouteGroupMember::setPort()
     * @uses LRouteGroupMember::setUuid()
     * @param string $deviceSelectionOrder
     * @param string $dialPlanWizardGenId
     * @param \StructType\XFkType $deviceName
     * @param string $port
     * @param string $uuid
     */
    public function __construct($deviceSelectionOrder = null, $dialPlanWizardGenId = null, \StructType\XFkType $deviceName = null, $port = null, $uuid = null)
    {
        $this
            ->setDeviceSelectionOrder($deviceSelectionOrder)
            ->setDialPlanWizardGenId($dialPlanWizardGenId)
            ->setDeviceName($deviceName)
            ->setPort($port)
            ->setUuid($uuid);
    }
    /**
     * Get deviceSelectionOrder value
     * @return string|null
     */
    public function getDeviceSelectionOrder()
    {
        return $this->deviceSelectionOrder;
    }
    /**
     * Set deviceSelectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSelectionOrder
     * @return \StructType\LRouteGroupMember
     */
    public function setDeviceSelectionOrder($deviceSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($deviceSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceSelectionOrder, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->deviceSelectionOrder = $deviceSelectionOrder;
        return $this;
    }
    /**
     * Get dialPlanWizardGenId value
     * @return string|null
     */
    public function getDialPlanWizardGenId()
    {
        return $this->dialPlanWizardGenId;
    }
    /**
     * Set dialPlanWizardGenId value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardGenId
     * @return \StructType\LRouteGroupMember
     */
    public function setDialPlanWizardGenId($dialPlanWizardGenId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dialPlanWizardGenId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardGenId, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardGenId = $dialPlanWizardGenId;
        return $this;
    }
    /**
     * Get deviceName value
     * @return \StructType\XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \StructType\XFkType $deviceName
     * @return \StructType\LRouteGroupMember
     */
    public function setDeviceName(\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\LRouteGroupMember
     */
    public function setPort($port = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LRouteGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LRouteGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
