<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRemoteCluster StructType
 * @subpackage Structs
 */
class LRemoteCluster extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $clusterId;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fullyQualifiedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $fullyQualifiedName;
    /**
     * The emcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $uds;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRemoteCluster
     * @uses LRemoteCluster::setClusterId()
     * @uses LRemoteCluster::setDescription()
     * @uses LRemoteCluster::setFullyQualifiedName()
     * @uses LRemoteCluster::setEmcc()
     * @uses LRemoteCluster::setPstnAccess()
     * @uses LRemoteCluster::setRsvpAgent()
     * @uses LRemoteCluster::setTftp()
     * @uses LRemoteCluster::setLbm()
     * @uses LRemoteCluster::setUds()
     * @uses LRemoteCluster::setUuid()
     * @param string $clusterId
     * @param string $description
     * @param string $fullyQualifiedName
     * @param \StructType\LRemoteClusterMember $emcc
     * @param \StructType\LRemoteClusterMember $pstnAccess
     * @param \StructType\LRemoteClusterMember $rsvpAgent
     * @param \StructType\LRemoteClusterMember $tftp
     * @param \StructType\LRemoteClusterMember $lbm
     * @param \StructType\LRemoteClusterMember $uds
     * @param string $uuid
     */
    public function __construct($clusterId = null, $description = null, $fullyQualifiedName = null, \StructType\LRemoteClusterMember $emcc = null, \StructType\LRemoteClusterMember $pstnAccess = null, \StructType\LRemoteClusterMember $rsvpAgent = null, \StructType\LRemoteClusterMember $tftp = null, \StructType\LRemoteClusterMember $lbm = null, \StructType\LRemoteClusterMember $uds = null, $uuid = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setDescription($description)
            ->setFullyQualifiedName($fullyQualifiedName)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds)
            ->setUuid($uuid);
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\LRemoteCluster
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 255) || (is_array($clusterId) && count($clusterId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LRemoteCluster
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fullyQualifiedName value
     * @return string|null
     */
    public function getFullyQualifiedName()
    {
        return $this->fullyQualifiedName;
    }
    /**
     * Set fullyQualifiedName value
     * @param string $fullyQualifiedName
     * @return \StructType\LRemoteCluster
     */
    public function setFullyQualifiedName($fullyQualifiedName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullyQualifiedName) && strlen($fullyQualifiedName) > 50) || (is_array($fullyQualifiedName) && count($fullyQualifiedName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($fullyQualifiedName) ? strlen($fullyQualifiedName) : count($fullyQualifiedName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullyQualifiedName) && !is_string($fullyQualifiedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullyQualifiedName)), __LINE__);
        }
        $this->fullyQualifiedName = $fullyQualifiedName;
        return $this;
    }
    /**
     * Get emcc value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param \StructType\LRemoteClusterMember $emcc
     * @return \StructType\LRemoteCluster
     */
    public function setEmcc(\StructType\LRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param \StructType\LRemoteClusterMember $pstnAccess
     * @return \StructType\LRemoteCluster
     */
    public function setPstnAccess(\StructType\LRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param \StructType\LRemoteClusterMember $rsvpAgent
     * @return \StructType\LRemoteCluster
     */
    public function setRsvpAgent(\StructType\LRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param \StructType\LRemoteClusterMember $tftp
     * @return \StructType\LRemoteCluster
     */
    public function setTftp(\StructType\LRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param \StructType\LRemoteClusterMember $lbm
     * @return \StructType\LRemoteCluster
     */
    public function setLbm(\StructType\LRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param \StructType\LRemoteClusterMember $uds
     * @return \StructType\LRemoteCluster
     */
    public function setUds(\StructType\LRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LRemoteCluster
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LRemoteCluster
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
