<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LProcessNodes StructType
 * @subpackage Structs
 */
class LProcessNodes extends AbstractStructBase
{
    /**
     * The lbmAssignedServices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $lbmAssignedServices;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LProcessNodes
     * @uses LProcessNodes::setLbmAssignedServices()
     * @uses LProcessNodes::setUuid()
     * @param \StructType\XFkType $lbmAssignedServices
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $lbmAssignedServices = null, $uuid = null)
    {
        $this
            ->setLbmAssignedServices($lbmAssignedServices)
            ->setUuid($uuid);
    }
    /**
     * Get lbmAssignedServices value
     * @return \StructType\XFkType|null
     */
    public function getLbmAssignedServices()
    {
        return $this->lbmAssignedServices;
    }
    /**
     * Set lbmAssignedServices value
     * @param \StructType\XFkType $lbmAssignedServices
     * @return \StructType\LProcessNodes
     */
    public function setLbmAssignedServices(\StructType\XFkType $lbmAssignedServices = null)
    {
        $this->lbmAssignedServices = $lbmAssignedServices;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LProcessNodes
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LProcessNodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
