<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LPresenceRedundancyGroup StructType
 * @subpackage Structs
 */
class LPresenceRedundancyGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The server1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $server1;
    /**
     * The server2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $server2;
    /**
     * The haEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $haEnabled;
    /**
     * The numUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numUsers;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LPresenceRedundancyGroup
     * @uses LPresenceRedundancyGroup::setName()
     * @uses LPresenceRedundancyGroup::setDescription()
     * @uses LPresenceRedundancyGroup::setServer1()
     * @uses LPresenceRedundancyGroup::setServer2()
     * @uses LPresenceRedundancyGroup::setHaEnabled()
     * @uses LPresenceRedundancyGroup::setNumUsers()
     * @uses LPresenceRedundancyGroup::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $server1
     * @param \StructType\XFkType $server2
     * @param string $haEnabled
     * @param string $numUsers
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $server1 = null, \StructType\XFkType $server2 = null, $haEnabled = null, $numUsers = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setServer1($server1)
            ->setServer2($server2)
            ->setHaEnabled($haEnabled)
            ->setNumUsers($numUsers)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LPresenceRedundancyGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LPresenceRedundancyGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get server1 value
     * @return \StructType\XFkType|null
     */
    public function getServer1()
    {
        return $this->server1;
    }
    /**
     * Set server1 value
     * @param \StructType\XFkType $server1
     * @return \StructType\LPresenceRedundancyGroup
     */
    public function setServer1(\StructType\XFkType $server1 = null)
    {
        $this->server1 = $server1;
        return $this;
    }
    /**
     * Get server2 value
     * @return \StructType\XFkType|null
     */
    public function getServer2()
    {
        return $this->server2;
    }
    /**
     * Set server2 value
     * @param \StructType\XFkType $server2
     * @return \StructType\LPresenceRedundancyGroup
     */
    public function setServer2(\StructType\XFkType $server2 = null)
    {
        $this->server2 = $server2;
        return $this;
    }
    /**
     * Get haEnabled value
     * @return string|null
     */
    public function getHaEnabled()
    {
        return $this->haEnabled;
    }
    /**
     * Set haEnabled value
     * @param string $haEnabled
     * @return \StructType\LPresenceRedundancyGroup
     */
    public function setHaEnabled($haEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($haEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($haEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($haEnabled) && !is_string($haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($haEnabled)), __LINE__);
        }
        $this->haEnabled = $haEnabled;
        return $this;
    }
    /**
     * Get numUsers value
     * @return string|null
     */
    public function getNumUsers()
    {
        return $this->numUsers;
    }
    /**
     * Set numUsers value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numUsers
     * @return \StructType\LPresenceRedundancyGroup
     */
    public function setNumUsers($numUsers = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($numUsers)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numUsers, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numUsers = $numUsers;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LPresenceRedundancyGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LPresenceRedundancyGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
