<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LEnterpriseAltNum StructType
 * @subpackage Structs
 */
class LEnterpriseAltNum extends AbstractStructBase
{
    /**
     * The numberMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberMask;
    /**
     * The addToLocalRoutePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $addToLocalRoutePartition;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $routePartition;
    /**
     * The isUrgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isUrgent;
    /**
     * The advertiseGloballyIls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $advertiseGloballyIls;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LEnterpriseAltNum
     * @uses LEnterpriseAltNum::setNumberMask()
     * @uses LEnterpriseAltNum::setAddToLocalRoutePartition()
     * @uses LEnterpriseAltNum::setRoutePartition()
     * @uses LEnterpriseAltNum::setIsUrgent()
     * @uses LEnterpriseAltNum::setAdvertiseGloballyIls()
     * @uses LEnterpriseAltNum::setUuid()
     * @param string $numberMask
     * @param string $addToLocalRoutePartition
     * @param \StructType\XFkType $routePartition
     * @param string $isUrgent
     * @param string $advertiseGloballyIls
     * @param string $uuid
     */
    public function __construct($numberMask = null, $addToLocalRoutePartition = null, \StructType\XFkType $routePartition = null, $isUrgent = null, $advertiseGloballyIls = null, $uuid = null)
    {
        $this
            ->setNumberMask($numberMask)
            ->setAddToLocalRoutePartition($addToLocalRoutePartition)
            ->setRoutePartition($routePartition)
            ->setIsUrgent($isUrgent)
            ->setAdvertiseGloballyIls($advertiseGloballyIls)
            ->setUuid($uuid);
    }
    /**
     * Get numberMask value
     * @return string|null
     */
    public function getNumberMask()
    {
        return $this->numberMask;
    }
    /**
     * Set numberMask value
     * @param string $numberMask
     * @return \StructType\LEnterpriseAltNum
     */
    public function setNumberMask($numberMask = null)
    {
        // validation for constraint: string
        if (!is_null($numberMask) && !is_string($numberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberMask)), __LINE__);
        }
        $this->numberMask = $numberMask;
        return $this;
    }
    /**
     * Get addToLocalRoutePartition value
     * @return string|null
     */
    public function getAddToLocalRoutePartition()
    {
        return $this->addToLocalRoutePartition;
    }
    /**
     * Set addToLocalRoutePartition value
     * @param string $addToLocalRoutePartition
     * @return \StructType\LEnterpriseAltNum
     */
    public function setAddToLocalRoutePartition($addToLocalRoutePartition = null)
    {
        // validation for constraint: pattern
        if (is_scalar($addToLocalRoutePartition) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $addToLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($addToLocalRoutePartition, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addToLocalRoutePartition) && !is_string($addToLocalRoutePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addToLocalRoutePartition)), __LINE__);
        }
        $this->addToLocalRoutePartition = $addToLocalRoutePartition;
        return $this;
    }
    /**
     * Get routePartition value
     * @return \StructType\XFkType|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param \StructType\XFkType $routePartition
     * @return \StructType\LEnterpriseAltNum
     */
    public function setRoutePartition(\StructType\XFkType $routePartition = null)
    {
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get isUrgent value
     * @return string|null
     */
    public function getIsUrgent()
    {
        return $this->isUrgent;
    }
    /**
     * Set isUrgent value
     * @param string $isUrgent
     * @return \StructType\LEnterpriseAltNum
     */
    public function setIsUrgent($isUrgent = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isUrgent) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isUrgent, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isUrgent) && !is_string($isUrgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isUrgent)), __LINE__);
        }
        $this->isUrgent = $isUrgent;
        return $this;
    }
    /**
     * Get advertiseGloballyIls value
     * @return string|null
     */
    public function getAdvertiseGloballyIls()
    {
        return $this->advertiseGloballyIls;
    }
    /**
     * Set advertiseGloballyIls value
     * @param string $advertiseGloballyIls
     * @return \StructType\LEnterpriseAltNum
     */
    public function setAdvertiseGloballyIls($advertiseGloballyIls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($advertiseGloballyIls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($advertiseGloballyIls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($advertiseGloballyIls) && !is_string($advertiseGloballyIls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertiseGloballyIls)), __LINE__);
        }
        $this->advertiseGloballyIls = $advertiseGloballyIls;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LEnterpriseAltNum
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LEnterpriseAltNum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
