<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LDirNumberAliasLookupandSync StructType
 * @subpackage Structs
 */
class LDirNumberAliasLookupandSync extends AbstractStructBase
{
    /**
     * The ldapConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $ldapConfigName;
    /**
     * The ldapManagerDisgName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ldapManagerDisgName;
    /**
     * The ldapPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ldapPassword;
    /**
     * The ldapUserSearch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $ldapUserSearch;
    /**
     * The ldapDirectoryServerUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapDirectoryServerUsage;
    /**
     * The keepAliveSearch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keepAliveSearch;
    /**
     * The keepAliveTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $keepAliveTime;
    /**
     * The sipAliasSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipAliasSuffix;
    /**
     * The enableCachingofRecords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCachingofRecords;
    /**
     * The cacheSizeforAliasLookup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cacheSizeforAliasLookup;
    /**
     * The cacheAgeforAliasLookup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cacheAgeforAliasLookup;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LDirNumberAliasLookupandSync
     * @uses LDirNumberAliasLookupandSync::setLdapConfigName()
     * @uses LDirNumberAliasLookupandSync::setLdapManagerDisgName()
     * @uses LDirNumberAliasLookupandSync::setLdapPassword()
     * @uses LDirNumberAliasLookupandSync::setLdapUserSearch()
     * @uses LDirNumberAliasLookupandSync::setLdapDirectoryServerUsage()
     * @uses LDirNumberAliasLookupandSync::setKeepAliveSearch()
     * @uses LDirNumberAliasLookupandSync::setKeepAliveTime()
     * @uses LDirNumberAliasLookupandSync::setSipAliasSuffix()
     * @uses LDirNumberAliasLookupandSync::setEnableCachingofRecords()
     * @uses LDirNumberAliasLookupandSync::setCacheSizeforAliasLookup()
     * @uses LDirNumberAliasLookupandSync::setCacheAgeforAliasLookup()
     * @uses LDirNumberAliasLookupandSync::setUuid()
     * @param string $ldapConfigName
     * @param string $ldapManagerDisgName
     * @param string $ldapPassword
     * @param string $ldapUserSearch
     * @param string $ldapDirectoryServerUsage
     * @param string $keepAliveSearch
     * @param string $keepAliveTime
     * @param string $sipAliasSuffix
     * @param string $enableCachingofRecords
     * @param string $cacheSizeforAliasLookup
     * @param string $cacheAgeforAliasLookup
     * @param string $uuid
     */
    public function __construct($ldapConfigName = null, $ldapManagerDisgName = null, $ldapPassword = null, $ldapUserSearch = null, $ldapDirectoryServerUsage = null, $keepAliveSearch = null, $keepAliveTime = null, $sipAliasSuffix = null, $enableCachingofRecords = null, $cacheSizeforAliasLookup = null, $cacheAgeforAliasLookup = null, $uuid = null)
    {
        $this
            ->setLdapConfigName($ldapConfigName)
            ->setLdapManagerDisgName($ldapManagerDisgName)
            ->setLdapPassword($ldapPassword)
            ->setLdapUserSearch($ldapUserSearch)
            ->setLdapDirectoryServerUsage($ldapDirectoryServerUsage)
            ->setKeepAliveSearch($keepAliveSearch)
            ->setKeepAliveTime($keepAliveTime)
            ->setSipAliasSuffix($sipAliasSuffix)
            ->setEnableCachingofRecords($enableCachingofRecords)
            ->setCacheSizeforAliasLookup($cacheSizeforAliasLookup)
            ->setCacheAgeforAliasLookup($cacheAgeforAliasLookup)
            ->setUuid($uuid);
    }
    /**
     * Get ldapConfigName value
     * @return string|null
     */
    public function getLdapConfigName()
    {
        return $this->ldapConfigName;
    }
    /**
     * Set ldapConfigName value
     * @param string $ldapConfigName
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapConfigName($ldapConfigName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapConfigName) && strlen($ldapConfigName) > 50) || (is_array($ldapConfigName) && count($ldapConfigName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($ldapConfigName) ? strlen($ldapConfigName) : count($ldapConfigName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapConfigName) && !is_string($ldapConfigName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapConfigName)), __LINE__);
        }
        $this->ldapConfigName = $ldapConfigName;
        return $this;
    }
    /**
     * Get ldapManagerDisgName value
     * @return string|null
     */
    public function getLdapManagerDisgName()
    {
        return $this->ldapManagerDisgName;
    }
    /**
     * Set ldapManagerDisgName value
     * @param string $ldapManagerDisgName
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapManagerDisgName($ldapManagerDisgName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapManagerDisgName) && strlen($ldapManagerDisgName) > 128) || (is_array($ldapManagerDisgName) && count($ldapManagerDisgName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapManagerDisgName) ? strlen($ldapManagerDisgName) : count($ldapManagerDisgName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapManagerDisgName) && !is_string($ldapManagerDisgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapManagerDisgName)), __LINE__);
        }
        $this->ldapManagerDisgName = $ldapManagerDisgName;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapPassword) && strlen($ldapPassword) > 128) || (is_array($ldapPassword) && count($ldapPassword) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapPassword) ? strlen($ldapPassword) : count($ldapPassword)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get ldapUserSearch value
     * @return string|null
     */
    public function getLdapUserSearch()
    {
        return $this->ldapUserSearch;
    }
    /**
     * Set ldapUserSearch value
     * @param string $ldapUserSearch
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapUserSearch($ldapUserSearch = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapUserSearch) && strlen($ldapUserSearch) > 255) || (is_array($ldapUserSearch) && count($ldapUserSearch) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($ldapUserSearch) ? strlen($ldapUserSearch) : count($ldapUserSearch)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapUserSearch) && !is_string($ldapUserSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapUserSearch)), __LINE__);
        }
        $this->ldapUserSearch = $ldapUserSearch;
        return $this;
    }
    /**
     * Get ldapDirectoryServerUsage value
     * @return string|null
     */
    public function getLdapDirectoryServerUsage()
    {
        return $this->ldapDirectoryServerUsage;
    }
    /**
     * Set ldapDirectoryServerUsage value
     * @uses \EnumType\XLDAPDirectoryFunction::valueIsValid()
     * @uses \EnumType\XLDAPDirectoryFunction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapDirectoryServerUsage
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setLdapDirectoryServerUsage($ldapDirectoryServerUsage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XLDAPDirectoryFunction::valueIsValid($ldapDirectoryServerUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ldapDirectoryServerUsage, implode(', ', \EnumType\XLDAPDirectoryFunction::getValidValues())), __LINE__);
        }
        $this->ldapDirectoryServerUsage = $ldapDirectoryServerUsage;
        return $this;
    }
    /**
     * Get keepAliveSearch value
     * @return string|null
     */
    public function getKeepAliveSearch()
    {
        return $this->keepAliveSearch;
    }
    /**
     * Set keepAliveSearch value
     * @param string $keepAliveSearch
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setKeepAliveSearch($keepAliveSearch = null)
    {
        // validation for constraint: string
        if (!is_null($keepAliveSearch) && !is_string($keepAliveSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keepAliveSearch)), __LINE__);
        }
        $this->keepAliveSearch = $keepAliveSearch;
        return $this;
    }
    /**
     * Get keepAliveTime value
     * @return string|null
     */
    public function getKeepAliveTime()
    {
        return $this->keepAliveTime;
    }
    /**
     * Set keepAliveTime value
     * @uses \EnumType\XKeepAliveTimeInterval::valueIsValid()
     * @uses \EnumType\XKeepAliveTimeInterval::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keepAliveTime
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setKeepAliveTime($keepAliveTime = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeepAliveTimeInterval::valueIsValid($keepAliveTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keepAliveTime, implode(', ', \EnumType\XKeepAliveTimeInterval::getValidValues())), __LINE__);
        }
        $this->keepAliveTime = $keepAliveTime;
        return $this;
    }
    /**
     * Get sipAliasSuffix value
     * @return string|null
     */
    public function getSipAliasSuffix()
    {
        return $this->sipAliasSuffix;
    }
    /**
     * Set sipAliasSuffix value
     * @param string $sipAliasSuffix
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setSipAliasSuffix($sipAliasSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipAliasSuffix) && !is_string($sipAliasSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sipAliasSuffix)), __LINE__);
        }
        $this->sipAliasSuffix = $sipAliasSuffix;
        return $this;
    }
    /**
     * Get enableCachingofRecords value
     * @return string|null
     */
    public function getEnableCachingofRecords()
    {
        return $this->enableCachingofRecords;
    }
    /**
     * Set enableCachingofRecords value
     * @param string $enableCachingofRecords
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setEnableCachingofRecords($enableCachingofRecords = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableCachingofRecords) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCachingofRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableCachingofRecords, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableCachingofRecords) && !is_string($enableCachingofRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCachingofRecords)), __LINE__);
        }
        $this->enableCachingofRecords = $enableCachingofRecords;
        return $this;
    }
    /**
     * Get cacheSizeforAliasLookup value
     * @return string|null
     */
    public function getCacheSizeforAliasLookup()
    {
        return $this->cacheSizeforAliasLookup;
    }
    /**
     * Set cacheSizeforAliasLookup value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cacheSizeforAliasLookup
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setCacheSizeforAliasLookup($cacheSizeforAliasLookup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($cacheSizeforAliasLookup)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cacheSizeforAliasLookup, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->cacheSizeforAliasLookup = $cacheSizeforAliasLookup;
        return $this;
    }
    /**
     * Get cacheAgeforAliasLookup value
     * @return string|null
     */
    public function getCacheAgeforAliasLookup()
    {
        return $this->cacheAgeforAliasLookup;
    }
    /**
     * Set cacheAgeforAliasLookup value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cacheAgeforAliasLookup
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setCacheAgeforAliasLookup($cacheAgeforAliasLookup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($cacheAgeforAliasLookup)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cacheAgeforAliasLookup, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->cacheAgeforAliasLookup = $cacheAgeforAliasLookup;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LDirNumberAliasLookupandSync
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
