<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCallForwardOnFailure StructType
 * @subpackage Structs
 */
class LCallForwardOnFailure extends AbstractStructBase
{
    /**
     * The forwardToVoiceMail
     * Meta informations extracted from the WSDL
     * - documentation: DB: Derived from CF*VoiceMailEnabled fields. This tag has been marked as ReadOnly for callForwardAlternateParty as it is not applicable for callForwardAlternateParty setting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardToVoiceMail;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $destination;
    /**
     * Constructor method for LCallForwardOnFailure
     * @uses LCallForwardOnFailure::setForwardToVoiceMail()
     * @uses LCallForwardOnFailure::setCallingSearchSpaceName()
     * @uses LCallForwardOnFailure::setDestination()
     * @param string $forwardToVoiceMail
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param string $destination
     */
    public function __construct($forwardToVoiceMail = null, \StructType\XFkType $callingSearchSpaceName = null, $destination = null)
    {
        $this
            ->setForwardToVoiceMail($forwardToVoiceMail)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDestination($destination);
    }
    /**
     * Get forwardToVoiceMail value
     * @return string|null
     */
    public function getForwardToVoiceMail()
    {
        return $this->forwardToVoiceMail;
    }
    /**
     * Set forwardToVoiceMail value
     * @param string $forwardToVoiceMail
     * @return \StructType\LCallForwardOnFailure
     */
    public function setForwardToVoiceMail($forwardToVoiceMail = null)
    {
        // validation for constraint: pattern
        if (is_scalar($forwardToVoiceMail) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($forwardToVoiceMail, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardToVoiceMail) && !is_string($forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardToVoiceMail)), __LINE__);
        }
        $this->forwardToVoiceMail = $forwardToVoiceMail;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\LCallForwardOnFailure
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\LCallForwardOnFailure
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destination) && strlen($destination) > 50) || (is_array($destination) && count($destination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destination) ? strlen($destination) : count($destination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LCallForwardOnFailure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
