<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LBusyLampField StructType
 * @subpackage Structs
 */
class LBusyLampField extends AbstractStructBase
{
    /**
     * The blfDest
     * Meta informations extracted from the WSDL
     * - documentation: Either blfDest or the combination of blfDirn and routePartition is to be mentioned in the add/update request, if both are mentioned AXL will read only the blfDest tag and ignore blfDirn and routePartition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blfDest;
    /**
     * The blfDirn
     * Meta informations extracted from the WSDL
     * - documentation: Either blfDest or the combination of blfDirn and routePartition is to be mentioned in the add/update request, if both are mentioned AXL will read only the blfDest tag and ignore blfDirn and routePartition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $blfDirn;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The associatedBlfSdFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedBlfSdFeatures
     */
    public $associatedBlfSdFeatures;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * Constructor method for LBusyLampField
     * @uses LBusyLampField::setBlfDest()
     * @uses LBusyLampField::setBlfDirn()
     * @uses LBusyLampField::setRoutePartition()
     * @uses LBusyLampField::setLabel()
     * @uses LBusyLampField::setAssociatedBlfSdFeatures()
     * @uses LBusyLampField::setIndex()
     * @param string $blfDest
     * @param string $blfDirn
     * @param string $routePartition
     * @param string $label
     * @param \StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures
     * @param string $index
     */
    public function __construct($blfDest = null, $blfDirn = null, $routePartition = null, $label = null, \StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures = null, $index = null)
    {
        $this
            ->setBlfDest($blfDest)
            ->setBlfDirn($blfDirn)
            ->setRoutePartition($routePartition)
            ->setLabel($label)
            ->setAssociatedBlfSdFeatures($associatedBlfSdFeatures)
            ->setIndex($index);
    }
    /**
     * Get blfDest value
     * @return string|null
     */
    public function getBlfDest()
    {
        return $this->blfDest;
    }
    /**
     * Set blfDest value
     * @param string $blfDest
     * @return \StructType\LBusyLampField
     */
    public function setBlfDest($blfDest = null)
    {
        // validation for constraint: string
        if (!is_null($blfDest) && !is_string($blfDest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blfDest)), __LINE__);
        }
        $this->blfDest = $blfDest;
        return $this;
    }
    /**
     * Get blfDirn value
     * @return string|null
     */
    public function getBlfDirn()
    {
        return $this->blfDirn;
    }
    /**
     * Set blfDirn value
     * @param string $blfDirn
     * @return \StructType\LBusyLampField
     */
    public function setBlfDirn($blfDirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($blfDirn) && strlen($blfDirn) > 255) || (is_array($blfDirn) && count($blfDirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($blfDirn) ? strlen($blfDirn) : count($blfDirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blfDirn) && !is_string($blfDirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blfDirn)), __LINE__);
        }
        $this->blfDirn = $blfDirn;
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param string $routePartition
     * @return \StructType\LBusyLampField
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartition)), __LINE__);
        }
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\LBusyLampField
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get associatedBlfSdFeatures value
     * @return \StructType\AssociatedBlfSdFeatures|null
     */
    public function getAssociatedBlfSdFeatures()
    {
        return $this->associatedBlfSdFeatures;
    }
    /**
     * Set associatedBlfSdFeatures value
     * @param \StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures
     * @return \StructType\LBusyLampField
     */
    public function setAssociatedBlfSdFeatures(\StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures = null)
    {
        $this->associatedBlfSdFeatures = $associatedBlfSdFeatures;
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\LBusyLampField
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LBusyLampField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
