<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAppServerInfo StructType
 * @subpackage Structs
 */
class LAppServerInfo extends AbstractStructBase
{
    /**
     * The appServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $appServerName;
    /**
     * The appServerContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appServerContent;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XContent
     */
    public $content;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAppServerInfo
     * @uses LAppServerInfo::setAppServerName()
     * @uses LAppServerInfo::setAppServerContent()
     * @uses LAppServerInfo::setContent()
     * @uses LAppServerInfo::setUuid()
     * @param \StructType\XFkType $appServerName
     * @param string $appServerContent
     * @param \StructType\XContent $content
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $appServerName = null, $appServerContent = null, \StructType\XContent $content = null, $uuid = null)
    {
        $this
            ->setAppServerName($appServerName)
            ->setAppServerContent($appServerContent)
            ->setContent($content)
            ->setUuid($uuid);
    }
    /**
     * Get appServerName value
     * @return \StructType\XFkType|null
     */
    public function getAppServerName()
    {
        return $this->appServerName;
    }
    /**
     * Set appServerName value
     * @param \StructType\XFkType $appServerName
     * @return \StructType\LAppServerInfo
     */
    public function setAppServerName(\StructType\XFkType $appServerName = null)
    {
        $this->appServerName = $appServerName;
        return $this;
    }
    /**
     * Get appServerContent value
     * @return string|null
     */
    public function getAppServerContent()
    {
        return $this->appServerContent;
    }
    /**
     * Set appServerContent value
     * @uses \EnumType\XAppServerContent::valueIsValid()
     * @uses \EnumType\XAppServerContent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerContent
     * @return \StructType\LAppServerInfo
     */
    public function setAppServerContent($appServerContent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAppServerContent::valueIsValid($appServerContent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appServerContent, implode(', ', \EnumType\XAppServerContent::getValidValues())), __LINE__);
        }
        $this->appServerContent = $appServerContent;
        return $this;
    }
    /**
     * Get content value
     * @return \StructType\XContent|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param \StructType\XContent $content
     * @return \StructType\LAppServerInfo
     */
    public function setContent(\StructType\XContent $content = null)
    {
        $this->content = $content;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LAppServerInfo
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LAppServerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
