<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSNMPCommunityStringReq StructType
 * @subpackage Structs
 */
class GetSNMPCommunityStringReq extends APIRequest
{
    /**
     * The communityName
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $communityName;
    /**
     * Constructor method for GetSNMPCommunityStringReq
     * @uses GetSNMPCommunityStringReq::setCommunityName()
     * @param string $communityName
     */
    public function __construct($communityName = null)
    {
        $this
            ->setCommunityName($communityName);
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return \StructType\GetSNMPCommunityStringReq
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($communityName) && strlen($communityName) > 32) || (is_array($communityName) && count($communityName) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($communityName) ? strlen($communityName) : count($communityName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSNMPCommunityStringReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
