<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteSQLQueryReq StructType
 * @subpackage Structs
 */
class ExecuteSQLQueryReq extends APIRequest
{
    /**
     * The sql
     * Meta informations extracted from the WSDL
     * - documentation: WARNING: SQL Large Text and BLOB columns cannot be fetched along with other columns. A Large Text or BLOB column must be selected in its own SQL query.
     * - nillable: false
     * @var string
     */
    public $sql;
    /**
     * Constructor method for ExecuteSQLQueryReq
     * @uses ExecuteSQLQueryReq::setSql()
     * @param string $sql
     */
    public function __construct($sql = null)
    {
        $this
            ->setSql($sql);
    }
    /**
     * Get sql value
     * @return string|null
     */
    public function getSql()
    {
        return $this->sql;
    }
    /**
     * Set sql value
     * @param string $sql
     * @return \StructType\ExecuteSQLQueryReq
     */
    public function setSql($sql = null)
    {
        // validation for constraint: string
        if (!is_null($sql) && !is_string($sql)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sql)), __LINE__);
        }
        $this->sql = $sql;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExecuteSQLQueryReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
