<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoAuthenticateUserReq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Authenticates the user on the basis of pin or password.
 * @subpackage Structs
 */
class DoAuthenticateUserReq extends APIRequest
{
    /**
     * The userid
     * @var string
     */
    public $userid;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta informations extracted from the WSDL
     * - documentation: Applicable for end users only.
     * - pattern: \d\d\d\d+
     * @var string
     */
    public $pin;
    /**
     * Constructor method for DoAuthenticateUserReq
     * @uses DoAuthenticateUserReq::setUserid()
     * @uses DoAuthenticateUserReq::setPassword()
     * @uses DoAuthenticateUserReq::setPin()
     * @param string $userid
     * @param string $password
     * @param string $pin
     */
    public function __construct($userid = null, $password = null, $pin = null)
    {
        $this
            ->setUserid($userid)
            ->setPassword($password)
            ->setPin($pin);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\DoAuthenticateUserReq
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\DoAuthenticateUserReq
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \StructType\DoAuthenticateUserReq
     */
    public function setPin($pin = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pin) && !preg_match('/\\d\\d\\d\\d+/', $pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\d\d\d\d+", "%s" given', var_export($pin, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoAuthenticateUserReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
