<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for confidentialAccess StructType
 * @subpackage Structs
 */
class ConfidentialAccess extends AbstractStructBase
{
    /**
     * The confidentialAccessMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $confidentialAccessMode;
    /**
     * The confidentialAccessLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $confidentialAccessLevel;
    /**
     * Constructor method for confidentialAccess
     * @uses ConfidentialAccess::setConfidentialAccessMode()
     * @uses ConfidentialAccess::setConfidentialAccessLevel()
     * @param string $confidentialAccessMode
     * @param string $confidentialAccessLevel
     */
    public function __construct($confidentialAccessMode = null, $confidentialAccessLevel = null)
    {
        $this
            ->setConfidentialAccessMode($confidentialAccessMode)
            ->setConfidentialAccessLevel($confidentialAccessLevel);
    }
    /**
     * Get confidentialAccessMode value
     * @return string
     */
    public function getConfidentialAccessMode()
    {
        return $this->confidentialAccessMode;
    }
    /**
     * Set confidentialAccessMode value
     * @uses \EnumType\XCALMode::valueIsValid()
     * @uses \EnumType\XCALMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentialAccessMode
     * @return \StructType\ConfidentialAccess
     */
    public function setConfidentialAccessMode($confidentialAccessMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCALMode::valueIsValid($confidentialAccessMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $confidentialAccessMode, implode(', ', \EnumType\XCALMode::getValidValues())), __LINE__);
        }
        $this->confidentialAccessMode = $confidentialAccessMode;
        return $this;
    }
    /**
     * Get confidentialAccessLevel value
     * @return string
     */
    public function getConfidentialAccessLevel()
    {
        return $this->confidentialAccessLevel;
    }
    /**
     * Set confidentialAccessLevel value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentialAccessLevel
     * @return \StructType\ConfidentialAccess
     */
    public function setConfidentialAccessLevel($confidentialAccessLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($confidentialAccessLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $confidentialAccessLevel, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->confidentialAccessLevel = $confidentialAccessLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConfidentialAccess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
