<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for codecsInList StructType
 * @subpackage Structs
 */
class CodecsInList extends AbstractStructBase
{
    /**
     * The codecNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var string[]
     */
    public $codecNames;
    /**
     * Constructor method for codecsInList
     * @uses CodecsInList::setCodecNames()
     * @param string[] $codecNames
     */
    public function __construct(array $codecNames = array())
    {
        $this
            ->setCodecNames($codecNames);
    }
    /**
     * Get codecNames value
     * @return string[]|null
     */
    public function getCodecNames()
    {
        return $this->codecNames;
    }
    /**
     * Set codecNames value
     * @throws \InvalidArgumentException
     * @param string[] $codecNames
     * @return \StructType\CodecsInList
     */
    public function setCodecNames(array $codecNames = array())
    {
        foreach ($codecNames as $codecsInListCodecNamesItem) {
            // validation for constraint: itemType
            if (!is_string($codecsInListCodecNamesItem)) {
                throw new \InvalidArgumentException(sprintf('The codecNames property can only contain items of string, "%s" given', is_object($codecsInListCodecNamesItem) ? get_class($codecsInListCodecNamesItem) : gettype($codecsInListCodecNamesItem)), __LINE__);
            }
        }
        $this->codecNames = $codecNames;
        return $this;
    }
    /**
     * Add item to codecNames value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CodecsInList
     */
    public function addToCodecNames($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The codecNames property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->codecNames[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodecsInList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
