<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedEndusers StructType
 * @subpackage Structs
 */
class AssociatedEndusers extends AbstractStructBase
{
    /**
     * The enduser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LEnduserMember[]
     */
    public $enduser;
    /**
     * Constructor method for associatedEndusers
     * @uses AssociatedEndusers::setEnduser()
     * @param \StructType\LEnduserMember[] $enduser
     */
    public function __construct(array $enduser = array())
    {
        $this
            ->setEnduser($enduser);
    }
    /**
     * Get enduser value
     * @return \StructType\LEnduserMember[]|null
     */
    public function getEnduser()
    {
        return $this->enduser;
    }
    /**
     * Set enduser value
     * @throws \InvalidArgumentException
     * @param \StructType\LEnduserMember[] $enduser
     * @return \StructType\AssociatedEndusers
     */
    public function setEnduser(array $enduser = array())
    {
        foreach ($enduser as $associatedEndusersEnduserItem) {
            // validation for constraint: itemType
            if (!$associatedEndusersEnduserItem instanceof \StructType\LEnduserMember) {
                throw new \InvalidArgumentException(sprintf('The enduser property can only contain items of \StructType\LEnduserMember, "%s" given', is_object($associatedEndusersEnduserItem) ? get_class($associatedEndusersEnduserItem) : gettype($associatedEndusersEnduserItem)), __LINE__);
            }
        }
        $this->enduser = $enduser;
        return $this;
    }
    /**
     * Add item to enduser value
     * @throws \InvalidArgumentException
     * @param \StructType\LEnduserMember $item
     * @return \StructType\AssociatedEndusers
     */
    public function addToEnduser(\StructType\LEnduserMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LEnduserMember) {
            throw new \InvalidArgumentException(sprintf('The enduser property can only contain items of \StructType\LEnduserMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->enduser[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociatedEndusers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
