<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssignPresenceUserReq StructType
 * @subpackage Structs
 */
class AssignPresenceUserReq extends APIRequest
{
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $userid;
    /**
     * The server
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $server;
    /**
     * Constructor method for AssignPresenceUserReq
     * @uses AssignPresenceUserReq::setUserid()
     * @uses AssignPresenceUserReq::setServer()
     * @param string $userid
     * @param string $server
     */
    public function __construct($userid = null, $server = null)
    {
        $this
            ->setUserid($userid)
            ->setServer($server);
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\AssignPresenceUserReq
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get server value
     * @return string
     */
    public function getServer()
    {
        return $this->server;
    }
    /**
     * Set server value
     * @param string $server
     * @return \StructType\AssignPresenceUserReq
     */
    public function setServer($server = null)
    {
        // validation for constraint: string
        if (!is_null($server) && !is_string($server)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($server)), __LINE__);
        }
        $this->server = $server;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssignPresenceUserReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
