<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addElinNumbers StructType
 * @subpackage Structs
 */
class AddElinNumbers extends XCommonMembersExtension
{
    /**
     * The elinNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XELINNumber[]
     */
    public $elinNumber;
    /**
     * Constructor method for addElinNumbers
     * @uses AddElinNumbers::setElinNumber()
     * @param \StructType\XELINNumber[] $elinNumber
     */
    public function __construct(array $elinNumber = array())
    {
        $this
            ->setElinNumber($elinNumber);
    }
    /**
     * Get elinNumber value
     * @return \StructType\XELINNumber[]
     */
    public function getElinNumber()
    {
        return $this->elinNumber;
    }
    /**
     * Set elinNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\XELINNumber[] $elinNumber
     * @return \StructType\AddElinNumbers
     */
    public function setElinNumber(array $elinNumber = array())
    {
        foreach ($elinNumber as $addElinNumbersElinNumberItem) {
            // validation for constraint: itemType
            if (!$addElinNumbersElinNumberItem instanceof \StructType\XELINNumber) {
                throw new \InvalidArgumentException(sprintf('The elinNumber property can only contain items of \StructType\XELINNumber, "%s" given', is_object($addElinNumbersElinNumberItem) ? get_class($addElinNumbersElinNumberItem) : gettype($addElinNumbersElinNumberItem)), __LINE__);
            }
        }
        $this->elinNumber = $elinNumber;
        return $this;
    }
    /**
     * Add item to elinNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\XELINNumber $item
     * @return \StructType\AddElinNumbers
     */
    public function addToElinNumber(\StructType\XELINNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XELINNumber) {
            throw new \InvalidArgumentException(sprintf('The elinNumber property can only contain items of \StructType\XELINNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->elinNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddElinNumbers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
