<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named listSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSipProfileReq $axlParams
     * @return \StructType\ListSipProfileRes|bool
     */
    public function listSipProfile(\StructType\ListSipProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSipTrunkSecurityProfileReq $axlParams
     * @return \StructType\ListSipTrunkSecurityProfileRes|bool
     */
    public function listSipTrunkSecurityProfile(\StructType\ListSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTimePeriodReq $axlParams
     * @return \StructType\ListTimePeriodRes|bool
     */
    public function listTimePeriod(\StructType\ListTimePeriodReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTimeScheduleReq $axlParams
     * @return \StructType\ListTimeScheduleRes|bool
     */
    public function listTimeSchedule(\StructType\ListTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTodAccessReq $axlParams
     * @return \StructType\ListTodAccessRes|bool
     */
    public function listTodAccess(\StructType\ListTodAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListVoiceMailPilotReq $axlParams
     * @return \StructType\ListVoiceMailPilotRes|bool
     */
    public function listVoiceMailPilot(\StructType\ListVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListProcessNodeReq $axlParams
     * @return \StructType\ListProcessNodeRes|bool
     */
    public function listProcessNode(\StructType\ListProcessNodeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCallerFilterListReq $axlParams
     * @return \StructType\ListCallerFilterListRes|bool
     */
    public function listCallerFilterList(\StructType\ListCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRoutePartitionReq $axlParams
     * @return \StructType\ListRoutePartitionRes|bool
     */
    public function listRoutePartition(\StructType\ListRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCssReq $axlParams
     * @return \StructType\ListCssRes|bool
     */
    public function listCss(\StructType\ListCssReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCallManagerReq $axlParams
     * @return \StructType\ListCallManagerRes|bool
     */
    public function listCallManager(\StructType\ListCallManagerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMediaResourceGroupReq $axlParams
     * @return \StructType\ListMediaResourceGroupRes|bool
     */
    public function listMediaResourceGroup(\StructType\ListMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMediaResourceListReq $axlParams
     * @return \StructType\ListMediaResourceListRes|bool
     */
    public function listMediaResourceList(\StructType\ListMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRegionReq $axlParams
     * @return \StructType\ListRegionRes|bool
     */
    public function listRegion(\StructType\ListRegionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAarGroupReq $axlParams
     * @return \StructType\ListAarGroupRes|bool
     */
    public function listAarGroup(\StructType\ListAarGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPhysicalLocationReq $axlParams
     * @return \StructType\ListPhysicalLocationRes|bool
     */
    public function listPhysicalLocation(\StructType\ListPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRouteGroupReq $axlParams
     * @return \StructType\ListRouteGroupRes|bool
     */
    public function listRouteGroup(\StructType\ListRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDevicePoolReq $axlParams
     * @return \StructType\ListDevicePoolRes|bool
     */
    public function listDevicePool(\StructType\ListDevicePoolReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDeviceMobilityGroupReq $axlParams
     * @return \StructType\ListDeviceMobilityGroupRes|bool
     */
    public function listDeviceMobilityGroup(\StructType\ListDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLocationReq $axlParams
     * @return \StructType\ListLocationRes|bool
     */
    public function listLocation(\StructType\ListLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSoftKeyTemplateReq $axlParams
     * @return \StructType\ListSoftKeyTemplateRes|bool
     */
    public function listSoftKeyTemplate(\StructType\ListSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTranscoderReq $axlParams
     * @return \StructType\ListTranscoderRes|bool
     */
    public function listTranscoder(\StructType\ListTranscoderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCommonDeviceConfigReq $axlParams
     * @return \StructType\ListCommonDeviceConfigRes|bool
     */
    public function listCommonDeviceConfig(\StructType\ListCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListResourcePriorityNamespaceReq $axlParams
     * @return \StructType\ListResourcePriorityNamespaceRes|bool
     */
    public function listResourcePriorityNamespace(\StructType\ListResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListResourcePriorityNamespaceListReq $axlParams
     * @return \StructType\ListResourcePriorityNamespaceListRes|bool
     */
    public function listResourcePriorityNamespaceList(\StructType\ListResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDeviceMobilityReq $axlParams
     * @return \StructType\ListDeviceMobilityRes|bool
     */
    public function listDeviceMobility(\StructType\ListDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCmcInfoReq $axlParams
     * @return \StructType\ListCmcInfoRes|bool
     */
    public function listCmcInfo(\StructType\ListCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCredentialPolicyReq $axlParams
     * @return \StructType\ListCredentialPolicyRes|bool
     */
    public function listCredentialPolicy(\StructType\ListCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListFacInfoReq $axlParams
     * @return \StructType\ListFacInfoRes|bool
     */
    public function listFacInfo(\StructType\ListFacInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListHuntListReq $axlParams
     * @return \StructType\ListHuntListRes|bool
     */
    public function listHuntList(\StructType\ListHuntListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListIvrUserLocaleReq $axlParams
     * @return \StructType\ListIvrUserLocaleRes|bool
     */
    public function listIvrUserLocale(\StructType\ListIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLineGroupReq $axlParams
     * @return \StructType\ListLineGroupRes|bool
     */
    public function listLineGroup(\StructType\ListLineGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRecordingProfileReq $axlParams
     * @return \StructType\ListRecordingProfileRes|bool
     */
    public function listRecordingProfile(\StructType\ListRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRouteFilterReq $axlParams
     * @return \StructType\ListRouteFilterRes|bool
     */
    public function listRouteFilter(\StructType\ListRouteFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCallManagerGroupReq $axlParams
     * @return \StructType\ListCallManagerGroupRes|bool
     */
    public function listCallManagerGroup(\StructType\ListCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUserGroupReq $axlParams
     * @return \StructType\ListUserGroupRes|bool
     */
    public function listUserGroup(\StructType\ListUserGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDialPlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDialPlanReq $axlParams
     * @return \StructType\ListDialPlanRes|bool
     */
    public function listDialPlan(\StructType\ListDialPlanReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDialPlan($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDialPlanTag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDialPlanTagReq $axlParams
     * @return \StructType\ListDialPlanTagRes|bool
     */
    public function listDialPlanTag(\StructType\ListDialPlanTagReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDialPlanTag($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDdi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDdiReq $axlParams
     * @return \StructType\ListDdiRes|bool
     */
    public function listDdi(\StructType\ListDdiReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDdi($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMobileSmartClientProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMobileSmartClientProfileReq $axlParams
     * @return \StructType\ListMobileSmartClientProfileRes|bool
     */
    public function listMobileSmartClientProfile(\StructType\ListMobileSmartClientProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMobileSmartClientProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListProcessNodeServiceReq $axlParams
     * @return \StructType\ListProcessNodeServiceRes|bool
     */
    public function listProcessNodeService(\StructType\ListProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMohAudioSourceReq $axlParams
     * @return \StructType\ListMohAudioSourceRes|bool
     */
    public function listMohAudioSource(\StructType\ListMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDhcpServerReq $axlParams
     * @return \StructType\ListDhcpServerRes|bool
     */
    public function listDhcpServer(\StructType\ListDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDhcpSubnetReq $axlParams
     * @return \StructType\ListDhcpSubnetRes|bool
     */
    public function listDhcpSubnet(\StructType\ListDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCallParkReq $axlParams
     * @return \StructType\ListCallParkRes|bool
     */
    public function listCallPark(\StructType\ListCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDirectedCallParkReq $axlParams
     * @return \StructType\ListDirectedCallParkRes|bool
     */
    public function listDirectedCallPark(\StructType\ListDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMeetMeReq $axlParams
     * @return \StructType\ListMeetMeRes|bool
     */
    public function listMeetMe(\StructType\ListMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listConferenceNow
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListConferenceNowReq $axlParams
     * @return \StructType\ListConferenceNowRes|bool
     */
    public function listConferenceNow(\StructType\ListConferenceNowReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listConferenceNow($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRouteListReq $axlParams
     * @return \StructType\ListRouteListRes|bool
     */
    public function listRouteList(\StructType\ListRouteListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUserReq $axlParams
     * @return \StructType\ListUserRes|bool
     */
    public function listUser(\StructType\ListUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAppUserReq $axlParams
     * @return \StructType\ListAppUserRes|bool
     */
    public function listAppUser(\StructType\ListAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSipRealmReq $axlParams
     * @return \StructType\ListSipRealmRes|bool
     */
    public function listSipRealm(\StructType\ListSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPhoneNtpReq $axlParams
     * @return \StructType\ListPhoneNtpRes|bool
     */
    public function listPhoneNtp(\StructType\ListPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDateTimeGroupReq $axlParams
     * @return \StructType\ListDateTimeGroupRes|bool
     */
    public function listDateTimeGroup(\StructType\ListDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPresenceGroupReq $axlParams
     * @return \StructType\ListPresenceGroupRes|bool
     */
    public function listPresenceGroup(\StructType\ListPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListGeoLocationReq $axlParams
     * @return \StructType\ListGeoLocationRes|bool
     */
    public function listGeoLocation(\StructType\ListGeoLocationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSrstReq $axlParams
     * @return \StructType\ListSrstRes|bool
     */
    public function listSrst(\StructType\ListSrstReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMlppDomainReq $axlParams
     * @return \StructType\ListMlppDomainRes|bool
     */
    public function listMlppDomain(\StructType\ListMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCumaServerSecurityProfileReq $axlParams
     * @return \StructType\ListCumaServerSecurityProfileRes|bool
     */
    public function listCumaServerSecurityProfile(\StructType\ListCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListApplicationServerReq $axlParams
     * @return \StructType\ListApplicationServerRes|bool
     */
    public function listApplicationServer(\StructType\ListApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListApplicationUserCapfProfileReq $axlParams
     * @return \StructType\ListApplicationUserCapfProfileRes|bool
     */
    public function listApplicationUserCapfProfile(\StructType\ListApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListEndUserCapfProfileReq $axlParams
     * @return \StructType\ListEndUserCapfProfileRes|bool
     */
    public function listEndUserCapfProfile(\StructType\ListEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listServiceParameter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListServiceParameterReq $axlParams
     * @return \StructType\ListServiceParameterRes|bool
     */
    public function listServiceParameter(\StructType\ListServiceParameterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listServiceParameter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListGeoLocationFilterReq $axlParams
     * @return \StructType\ListGeoLocationFilterRes|bool
     */
    public function listGeoLocationFilter(\StructType\ListGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListVoiceMailProfileReq $axlParams
     * @return \StructType\ListVoiceMailProfileRes|bool
     */
    public function listVoiceMailProfile(\StructType\ListVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListVoiceMailPortReq $axlParams
     * @return \StructType\ListVoiceMailPortRes|bool
     */
    public function listVoiceMailPort(\StructType\ListVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListGatekeeperReq $axlParams
     * @return \StructType\ListGatekeeperRes|bool
     */
    public function listGatekeeper(\StructType\ListGatekeeperReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPhoneButtonTemplateReq $axlParams
     * @return \StructType\ListPhoneButtonTemplateRes|bool
     */
    public function listPhoneButtonTemplate(\StructType\ListPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCommonPhoneConfigReq $axlParams
     * @return \StructType\ListCommonPhoneConfigRes|bool
     */
    public function listCommonPhoneConfig(\StructType\ListCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMessageWaitingReq $axlParams
     * @return \StructType\ListMessageWaitingRes|bool
     */
    public function listMessageWaiting(\StructType\ListMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListIpPhoneServicesReq $axlParams
     * @return \StructType\ListIpPhoneServicesRes|bool
     */
    public function listIpPhoneServices(\StructType\ListIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCtiRoutePointReq $axlParams
     * @return \StructType\ListCtiRoutePointRes|bool
     */
    public function listCtiRoutePoint(\StructType\ListCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTransPatternReq $axlParams
     * @return \StructType\ListTransPatternRes|bool
     */
    public function listTransPattern(\StructType\ListTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCallingPartyTransformationPatternReq $axlParams
     * @return \StructType\ListCallingPartyTransformationPatternRes|bool
     */
    public function listCallingPartyTransformationPattern(\StructType\ListCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSipRoutePatternReq $axlParams
     * @return \StructType\ListSipRoutePatternRes|bool
     */
    public function listSipRoutePattern(\StructType\ListSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListHuntPilotReq $axlParams
     * @return \StructType\ListHuntPilotRes|bool
     */
    public function listHuntPilot(\StructType\ListHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRoutePatternReq $axlParams
     * @return \StructType\ListRoutePatternRes|bool
     */
    public function listRoutePattern(\StructType\ListRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListApplicationDialRulesReq $axlParams
     * @return \StructType\ListApplicationDialRulesRes|bool
     */
    public function listApplicationDialRules(\StructType\ListApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDirectoryLookupDialRulesReq $axlParams
     * @return \StructType\ListDirectoryLookupDialRulesRes|bool
     */
    public function listDirectoryLookupDialRules(\StructType\ListDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPhoneSecurityProfileReq $axlParams
     * @return \StructType\ListPhoneSecurityProfileRes|bool
     */
    public function listPhoneSecurityProfile(\StructType\ListPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSipDialRulesReq $axlParams
     * @return \StructType\ListSipDialRulesRes|bool
     */
    public function listSipDialRules(\StructType\ListSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListConferenceBridgeReq $axlParams
     * @return \StructType\ListConferenceBridgeRes|bool
     */
    public function listConferenceBridge(\StructType\ListConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAnnunciatorReq $axlParams
     * @return \StructType\ListAnnunciatorRes|bool
     */
    public function listAnnunciator(\StructType\ListAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listInteractiveVoiceResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListInteractiveVoiceResponseReq $axlParams
     * @return \StructType\ListInteractiveVoiceResponseRes|bool
     */
    public function listInteractiveVoiceResponse(\StructType\ListInteractiveVoiceResponseReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listInteractiveVoiceResponse($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMtpReq $axlParams
     * @return \StructType\ListMtpRes|bool
     */
    public function listMtp(\StructType\ListMtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRemoteDestinationProfileReq $axlParams
     * @return \StructType\ListRemoteDestinationProfileRes|bool
     */
    public function listRemoteDestinationProfile(\StructType\ListRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLineReq $axlParams
     * @return \StructType\ListLineRes|bool
     */
    public function listLine(\StructType\ListLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDefaultDeviceProfileReq $axlParams
     * @return \StructType\ListDefaultDeviceProfileRes|bool
     */
    public function listDefaultDeviceProfile(\StructType\ListDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListH323PhoneReq $axlParams
     * @return \StructType\ListH323PhoneRes|bool
     */
    public function listH323Phone(\StructType\ListH323PhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMohServerReq $axlParams
     * @return \StructType\ListMohServerRes|bool
     */
    public function listMohServer(\StructType\ListMohServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListH323TrunkReq $axlParams
     * @return \StructType\ListH323TrunkRes|bool
     */
    public function listH323Trunk(\StructType\ListH323TrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPhoneReq $axlParams
     * @return \StructType\ListPhoneRes|bool
     */
    public function listPhone(\StructType\ListPhoneReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListH323GatewayReq $axlParams
     * @return \StructType\ListH323GatewayRes|bool
     */
    public function listH323Gateway(\StructType\ListH323GatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDeviceProfileReq $axlParams
     * @return \StructType\ListDeviceProfileRes|bool
     */
    public function listDeviceProfile(\StructType\ListDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRemoteDestinationReq $axlParams
     * @return \StructType\ListRemoteDestinationRes|bool
     */
    public function listRemoteDestination(\StructType\ListRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListGatewayReq $axlParams
     * @return \StructType\ListGatewayRes|bool
     */
    public function listGateway(\StructType\ListGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \StructType\ListCiscoCatalyst600024PortFXSGatewayRes|bool
     */
    public function listCiscoCatalyst600024PortFXSGateway(\StructType\ListCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \StructType\ListCiscoCatalyst6000E1VoIPGatewayRes|bool
     */
    public function listCiscoCatalyst6000E1VoIPGateway(\StructType\ListCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \StructType\ListCiscoCatalyst6000T1VoIPGatewayPriRes|bool
     */
    public function listCiscoCatalyst6000T1VoIPGatewayPri(\StructType\ListCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Res|bool
     */
    public function listCiscoCatalyst6000T1VoIPGatewayT1(\StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCallPickupGroupReq $axlParams
     * @return \StructType\ListCallPickupGroupRes|bool
     */
    public function listCallPickupGroup(\StructType\ListCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRoutePlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRoutePlanReq $axlParams
     * @return \StructType\ListRoutePlanRes|bool
     */
    public function listRoutePlan(\StructType\ListRoutePlanReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRoutePlan($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListGeoLocationPolicyReq $axlParams
     * @return \StructType\ListGeoLocationPolicyRes|bool
     */
    public function listGeoLocationPolicy(\StructType\ListGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSipTrunkReq $axlParams
     * @return \StructType\ListSipTrunkRes|bool
     */
    public function listSipTrunk(\StructType\ListSipTrunkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCalledPartyTransformationPatternReq $axlParams
     * @return \StructType\ListCalledPartyTransformationPatternRes|bool
     */
    public function listCalledPartyTransformationPattern(\StructType\ListCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListExternalCallControlProfileReq $axlParams
     * @return \StructType\ListExternalCallControlProfileRes|bool
     */
    public function listExternalCallControlProfile(\StructType\ListExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSafSecurityProfileReq $axlParams
     * @return \StructType\ListSafSecurityProfileRes|bool
     */
    public function listSafSecurityProfile(\StructType\ListSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSafForwarderReq $axlParams
     * @return \StructType\ListSafForwarderRes|bool
     */
    public function listSafForwarder(\StructType\ListSafForwarderReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCcdHostedDNReq $axlParams
     * @return \StructType\ListCcdHostedDNRes|bool
     */
    public function listCcdHostedDN(\StructType\ListCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCcdHostedDNGroupReq $axlParams
     * @return \StructType\ListCcdHostedDNGroupRes|bool
     */
    public function listCcdHostedDNGroup(\StructType\ListCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRemoteClusterReq $axlParams
     * @return \StructType\ListRemoteClusterRes|bool
     */
    public function listRemoteCluster(\StructType\ListRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCcdAdvertisingServiceReq $axlParams
     * @return \StructType\ListCcdAdvertisingServiceRes|bool
     */
    public function listCcdAdvertisingService(\StructType\ListCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLdapDirectoryReq $axlParams
     * @return \StructType\ListLdapDirectoryRes|bool
     */
    public function listLdapDirectory(\StructType\ListLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \StructType\ListSafCcdPurgeBlockLearnedRoutesRes|bool
     */
    public function listSafCcdPurgeBlockLearnedRoutes(\StructType\ListSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListVpnGatewayReq $axlParams
     * @return \StructType\ListVpnGatewayRes|bool
     */
    public function listVpnGateway(\StructType\ListVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListVpnGroupReq $axlParams
     * @return \StructType\ListVpnGroupRes|bool
     */
    public function listVpnGroup(\StructType\ListVpnGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListVpnProfileReq $axlParams
     * @return \StructType\ListVpnProfileRes|bool
     */
    public function listVpnProfile(\StructType\ListVpnProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeServerReq $axlParams
     * @return \StructType\ListImeServerRes|bool
     */
    public function listImeServer(\StructType\ListImeServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeRouteFilterGroupReq $axlParams
     * @return \StructType\ListImeRouteFilterGroupRes|bool
     */
    public function listImeRouteFilterGroup(\StructType\ListImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeRouteFilterElementReq $axlParams
     * @return \StructType\ListImeRouteFilterElementRes|bool
     */
    public function listImeRouteFilterElement(\StructType\ListImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeClientReq $axlParams
     * @return \StructType\ListImeClientRes|bool
     */
    public function listImeClient(\StructType\ListImeClientReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeEnrolledPatternReq $axlParams
     * @return \StructType\ListImeEnrolledPatternRes|bool
     */
    public function listImeEnrolledPattern(\StructType\ListImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeEnrolledPatternGroupReq $axlParams
     * @return \StructType\ListImeEnrolledPatternGroupRes|bool
     */
    public function listImeEnrolledPatternGroup(\StructType\ListImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeExclusionNumberReq $axlParams
     * @return \StructType\ListImeExclusionNumberRes|bool
     */
    public function listImeExclusionNumber(\StructType\ListImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeExclusionNumberGroupReq $axlParams
     * @return \StructType\ListImeExclusionNumberGroupRes|bool
     */
    public function listImeExclusionNumberGroup(\StructType\ListImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeFirewallReq $axlParams
     * @return \StructType\ListImeFirewallRes|bool
     */
    public function listImeFirewall(\StructType\ListImeFirewallReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImeE164TransformationReq $axlParams
     * @return \StructType\ListImeE164TransformationRes|bool
     */
    public function listImeE164Transformation(\StructType\ListImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTransformationProfileReq $axlParams
     * @return \StructType\ListTransformationProfileRes|bool
     */
    public function listTransformationProfile(\StructType\ListTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListFallbackProfileReq $axlParams
     * @return \StructType\ListFallbackProfileRes|bool
     */
    public function listFallbackProfile(\StructType\ListFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLdapFilterReq $axlParams
     * @return \StructType\ListLdapFilterRes|bool
     */
    public function listLdapFilter(\StructType\ListLdapFilterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTvsCertificateReq $axlParams
     * @return \StructType\ListTvsCertificateRes|bool
     */
    public function listTvsCertificate(\StructType\ListTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListFeatureControlPolicyReq $axlParams
     * @return \StructType\ListFeatureControlPolicyRes|bool
     */
    public function listFeatureControlPolicy(\StructType\ListFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMobilityProfileReq $axlParams
     * @return \StructType\ListMobilityProfileRes|bool
     */
    public function listMobilityProfile(\StructType\ListMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \StructType\ListEnterpriseFeatureAccessConfigurationRes|bool
     */
    public function listEnterpriseFeatureAccessConfiguration(\StructType\ListEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCalledPartyTracing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCalledPartyTracingReq $axlParams
     * @return \StructType\ListCalledPartyTracingRes|bool
     */
    public function listCalledPartyTracing(\StructType\ListCalledPartyTracingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCalledPartyTracing($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSIPNormalizationScriptReq $axlParams
     * @return \StructType\ListSIPNormalizationScriptRes|bool
     */
    public function listSIPNormalizationScript(\StructType\ListSIPNormalizationScriptReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCustomUserFieldReq $axlParams
     * @return \StructType\ListCustomUserFieldRes|bool
     */
    public function listCustomUserField(\StructType\ListCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListBillingServerReq $axlParams
     * @return \StructType\ListBillingServerRes|bool
     */
    public function listBillingServer(\StructType\ListBillingServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLbmGroupReq $axlParams
     * @return \StructType\ListLbmGroupRes|bool
     */
    public function listLbmGroup(\StructType\ListLbmGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAnnouncementReq $axlParams
     * @return \StructType\ListAnnouncementRes|bool
     */
    public function listAnnouncement(\StructType\ListAnnouncementReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListServiceProfileReq $axlParams
     * @return \StructType\ListServiceProfileRes|bool
     */
    public function listServiceProfile(\StructType\ListServiceProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAudioCodecPreferenceListReq $axlParams
     * @return \StructType\ListAudioCodecPreferenceListRes|bool
     */
    public function listAudioCodecPreferenceList(\StructType\ListAudioCodecPreferenceListReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUcServiceReq $axlParams
     * @return \StructType\ListUcServiceRes|bool
     */
    public function listUcService(\StructType\ListUcServiceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLbmHubGroupReq $axlParams
     * @return \StructType\ListLbmHubGroupRes|bool
     */
    public function listLbmHubGroup(\StructType\ListLbmHubGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListImportedDirectoryUriCatalogsReq $axlParams
     * @return \StructType\ListImportedDirectoryUriCatalogsRes|bool
     */
    public function listImportedDirectoryUriCatalogs(\StructType\ListImportedDirectoryUriCatalogsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListVohServerReq $axlParams
     * @return \StructType\ListVohServerRes|bool
     */
    public function listVohServer(\StructType\ListVohServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListSdpTransparencyProfileReq $axlParams
     * @return \StructType\ListSdpTransparencyProfileRes|bool
     */
    public function listSdpTransparencyProfile(\StructType\ListSdpTransparencyProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListFeatureGroupTemplateReq $axlParams
     * @return \StructType\ListFeatureGroupTemplateRes|bool
     */
    public function listFeatureGroupTemplate(\StructType\ListFeatureGroupTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDirNumberAliasLookupandSyncReq $axlParams
     * @return \StructType\ListDirNumberAliasLookupandSyncRes|bool
     */
    public function listDirNumberAliasLookupandSync(\StructType\ListDirNumberAliasLookupandSyncReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLocalRouteGroupReq $axlParams
     * @return \StructType\ListLocalRouteGroupRes|bool
     */
    public function listLocalRouteGroup(\StructType\ListLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAdvertisedPatternsReq $axlParams
     * @return \StructType\ListAdvertisedPatternsRes|bool
     */
    public function listAdvertisedPatterns(\StructType\ListAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListBlockedLearnedPatternsReq $axlParams
     * @return \StructType\ListBlockedLearnedPatternsRes|bool
     */
    public function listBlockedLearnedPatterns(\StructType\ListBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListCCAProfilesReq $axlParams
     * @return \StructType\ListCCAProfilesRes|bool
     */
    public function listCCAProfiles(\StructType\ListCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUniversalDeviceTemplateReq $axlParams
     * @return \StructType\ListUniversalDeviceTemplateRes|bool
     */
    public function listUniversalDeviceTemplate(\StructType\ListUniversalDeviceTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUserProfileProvisionReq $axlParams
     * @return \StructType\ListUserProfileProvisionRes|bool
     */
    public function listUserProfileProvision(\StructType\ListUserProfileProvisionReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listPresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListPresenceRedundancyGroupReq $axlParams
     * @return \StructType\ListPresenceRedundancyGroupRes|bool
     */
    public function listPresenceRedundancyGroup(\StructType\ListPresenceRedundancyGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listPresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAssignedPresenceServers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAssignedPresenceServersReq $axlParams
     * @return \StructType\ListAssignedPresenceServersRes|bool
     */
    public function listAssignedPresenceServers(\StructType\ListAssignedPresenceServersReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAssignedPresenceServers($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUnassignedPresenceServers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUnassignedPresenceServersReq $axlParams
     * @return \StructType\ListUnassignedPresenceServersRes|bool
     */
    public function listUnassignedPresenceServers(\StructType\ListUnassignedPresenceServersReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUnassignedPresenceServers($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listAssignedPresenceUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListAssignedPresenceUsersReq $axlParams
     * @return \StructType\ListAssignedPresenceUsersRes|bool
     */
    public function listAssignedPresenceUsers(\StructType\ListAssignedPresenceUsersReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listAssignedPresenceUsers($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUnassignedPresenceUsers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUnassignedPresenceUsersReq $axlParams
     * @return \StructType\ListUnassignedPresenceUsersRes|bool
     */
    public function listUnassignedPresenceUsers(\StructType\ListUnassignedPresenceUsersReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUnassignedPresenceUsers($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListWifiHotspotReq $axlParams
     * @return \StructType\ListWifiHotspotRes|bool
     */
    public function listWifiHotspot(\StructType\ListWifiHotspotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListWlanProfileGroupReq $axlParams
     * @return \StructType\ListWlanProfileGroupRes|bool
     */
    public function listWlanProfileGroup(\StructType\ListWlanProfileGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListWLANProfileReq $axlParams
     * @return \StructType\ListWLANProfileRes|bool
     */
    public function listWLANProfile(\StructType\ListWLANProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUniversalLineTemplateReq $axlParams
     * @return \StructType\ListUniversalLineTemplateRes|bool
     */
    public function listUniversalLineTemplate(\StructType\ListUniversalLineTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListNetworkAccessProfileReq $axlParams
     * @return \StructType\ListNetworkAccessProfileRes|bool
     */
    public function listNetworkAccessProfile(\StructType\ListNetworkAccessProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLicensedUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLicensedUserReq $axlParams
     * @return \StructType\ListLicensedUserRes|bool
     */
    public function listLicensedUser(\StructType\ListLicensedUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLicensedUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listElinGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListElinGroupReq $axlParams
     * @return \StructType\ListElinGroupRes|bool
     */
    public function listElinGroup(\StructType\ListElinGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listElinGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listUnassignedDevice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListUnassignedDeviceReq $axlParams
     * @return \StructType\ListUnassignedDeviceRes|bool
     */
    public function listUnassignedDevice(\StructType\ListUnassignedDeviceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listUnassignedDevice($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLdapSyncCustomFieldReq $axlParams
     * @return \StructType\ListLdapSyncCustomFieldRes|bool
     */
    public function listLdapSyncCustomField(\StructType\ListLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListChangeReq $axlParams
     * @return \StructType\ListChangeRes|bool
     */
    public function listChange(\StructType\ListChangeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->listChange($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListAarGroupRes|\StructType\ListAdvertisedPatternsRes|\StructType\ListAnnouncementRes|\StructType\ListAnnunciatorRes|\StructType\ListApplicationDialRulesRes|\StructType\ListApplicationServerRes|\StructType\ListApplicationUserCapfProfileRes|\StructType\ListAppUserRes|\StructType\ListAssignedPresenceServersRes|\StructType\ListAssignedPresenceUsersRes|\StructType\ListAudioCodecPreferenceListRes|\StructType\ListBillingServerRes|\StructType\ListBlockedLearnedPatternsRes|\StructType\ListCalledPartyTracingRes|\StructType\ListCalledPartyTransformationPatternRes|\StructType\ListCallerFilterListRes|\StructType\ListCallingPartyTransformationPatternRes|\StructType\ListCallManagerGroupRes|\StructType\ListCallManagerRes|\StructType\ListCallParkRes|\StructType\ListCallPickupGroupRes|\StructType\ListCCAProfilesRes|\StructType\ListCcdAdvertisingServiceRes|\StructType\ListCcdHostedDNGroupRes|\StructType\ListCcdHostedDNRes|\StructType\ListChangeRes|\StructType\ListCiscoCatalyst6000E1VoIPGatewayRes|\StructType\ListCiscoCatalyst6000T1VoIPGatewayPriRes|\StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Res|\StructType\ListCiscoCatalyst600024PortFXSGatewayRes|\StructType\ListCmcInfoRes|\StructType\ListCommonDeviceConfigRes|\StructType\ListCommonPhoneConfigRes|\StructType\ListConferenceBridgeRes|\StructType\ListConferenceNowRes|\StructType\ListCredentialPolicyRes|\StructType\ListCssRes|\StructType\ListCtiRoutePointRes|\StructType\ListCumaServerSecurityProfileRes|\StructType\ListCustomUserFieldRes|\StructType\ListDateTimeGroupRes|\StructType\ListDdiRes|\StructType\ListDefaultDeviceProfileRes|\StructType\ListDeviceMobilityGroupRes|\StructType\ListDeviceMobilityRes|\StructType\ListDevicePoolRes|\StructType\ListDeviceProfileRes|\StructType\ListDhcpServerRes|\StructType\ListDhcpSubnetRes|\StructType\ListDialPlanRes|\StructType\ListDialPlanTagRes|\StructType\ListDirectedCallParkRes|\StructType\ListDirectoryLookupDialRulesRes|\StructType\ListDirNumberAliasLookupandSyncRes|\StructType\ListElinGroupRes|\StructType\ListEndUserCapfProfileRes|\StructType\ListEnterpriseFeatureAccessConfigurationRes|\StructType\ListExternalCallControlProfileRes|\StructType\ListFacInfoRes|\StructType\ListFallbackProfileRes|\StructType\ListFeatureControlPolicyRes|\StructType\ListFeatureGroupTemplateRes|\StructType\ListGatekeeperRes|\StructType\ListGatewayRes|\StructType\ListGeoLocationFilterRes|\StructType\ListGeoLocationPolicyRes|\StructType\ListGeoLocationRes|\StructType\ListH323GatewayRes|\StructType\ListH323PhoneRes|\StructType\ListH323TrunkRes|\StructType\ListHuntListRes|\StructType\ListHuntPilotRes|\StructType\ListImeClientRes|\StructType\ListImeE164TransformationRes|\StructType\ListImeEnrolledPatternGroupRes|\StructType\ListImeEnrolledPatternRes|\StructType\ListImeExclusionNumberGroupRes|\StructType\ListImeExclusionNumberRes|\StructType\ListImeFirewallRes|\StructType\ListImeRouteFilterElementRes|\StructType\ListImeRouteFilterGroupRes|\StructType\ListImeServerRes|\StructType\ListImportedDirectoryUriCatalogsRes|\StructType\ListInteractiveVoiceResponseRes|\StructType\ListIpPhoneServicesRes|\StructType\ListIvrUserLocaleRes|\StructType\ListLbmGroupRes|\StructType\ListLbmHubGroupRes|\StructType\ListLdapDirectoryRes|\StructType\ListLdapFilterRes|\StructType\ListLdapSyncCustomFieldRes|\StructType\ListLicensedUserRes|\StructType\ListLineGroupRes|\StructType\ListLineRes|\StructType\ListLocalRouteGroupRes|\StructType\ListLocationRes|\StructType\ListMediaResourceGroupRes|\StructType\ListMediaResourceListRes|\StructType\ListMeetMeRes|\StructType\ListMessageWaitingRes|\StructType\ListMlppDomainRes|\StructType\ListMobileSmartClientProfileRes|\StructType\ListMobilityProfileRes|\StructType\ListMohAudioSourceRes|\StructType\ListMohServerRes|\StructType\ListMtpRes|\StructType\ListNetworkAccessProfileRes|\StructType\ListPhoneButtonTemplateRes|\StructType\ListPhoneNtpRes|\StructType\ListPhoneRes|\StructType\ListPhoneSecurityProfileRes|\StructType\ListPhysicalLocationRes|\StructType\ListPresenceGroupRes|\StructType\ListPresenceRedundancyGroupRes|\StructType\ListProcessNodeRes|\StructType\ListProcessNodeServiceRes|\StructType\ListRecordingProfileRes|\StructType\ListRegionRes|\StructType\ListRemoteClusterRes|\StructType\ListRemoteDestinationProfileRes|\StructType\ListRemoteDestinationRes|\StructType\ListResourcePriorityNamespaceListRes|\StructType\ListResourcePriorityNamespaceRes|\StructType\ListRouteFilterRes|\StructType\ListRouteGroupRes|\StructType\ListRouteListRes|\StructType\ListRoutePartitionRes|\StructType\ListRoutePatternRes|\StructType\ListRoutePlanRes|\StructType\ListSafCcdPurgeBlockLearnedRoutesRes|\StructType\ListSafForwarderRes|\StructType\ListSafSecurityProfileRes|\StructType\ListSdpTransparencyProfileRes|\StructType\ListServiceParameterRes|\StructType\ListServiceProfileRes|\StructType\ListSipDialRulesRes|\StructType\ListSIPNormalizationScriptRes|\StructType\ListSipProfileRes|\StructType\ListSipRealmRes|\StructType\ListSipRoutePatternRes|\StructType\ListSipTrunkRes|\StructType\ListSipTrunkSecurityProfileRes|\StructType\ListSoftKeyTemplateRes|\StructType\ListSrstRes|\StructType\ListTimePeriodRes|\StructType\ListTimeScheduleRes|\StructType\ListTodAccessRes|\StructType\ListTranscoderRes|\StructType\ListTransformationProfileRes|\StructType\ListTransPatternRes|\StructType\ListTvsCertificateRes|\StructType\ListUcServiceRes|\StructType\ListUnassignedDeviceRes|\StructType\ListUnassignedPresenceServersRes|\StructType\ListUnassignedPresenceUsersRes|\StructType\ListUniversalDeviceTemplateRes|\StructType\ListUniversalLineTemplateRes|\StructType\ListUserGroupRes|\StructType\ListUserProfileProvisionRes|\StructType\ListUserRes|\StructType\ListVohServerRes|\StructType\ListVoiceMailPilotRes|\StructType\ListVoiceMailPortRes|\StructType\ListVoiceMailProfileRes|\StructType\ListVpnGatewayRes|\StructType\ListVpnGroupRes|\StructType\ListVpnProfileRes|\StructType\ListWifiHotspotRes|\StructType\ListWlanProfileGroupRes|\StructType\ListWLANProfileRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
