<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSipProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSipTrunkSecurityProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeTimePeriod(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeTimeSchedule(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeTodAccess(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveVoiceMailPilotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVoiceMailPilot(\StructType\RemoveVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeProcessNode(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCallerFilterList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRoutePartition(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCss(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMediaResourceGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMediaResourceList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRegion(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeAarGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removePhysicalLocation(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRouteGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDevicePool(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDeviceMobilityGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLocation(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSoftKeyTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeTranscoder(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCommonDeviceConfig(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveResourcePriorityNamespaceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeResourcePriorityNamespace(\StructType\RemoveResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeResourcePriorityNamespaceList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDeviceMobility(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCmcInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCmcInfo(\StructType\RemoveCmcInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCredentialPolicy(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeFacInfo(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeHuntList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveIvrUserLocaleReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeIvrUserLocale(\StructType\RemoveIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLineGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRecordingProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRouteFilter(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCallManagerGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeUserGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveMohAudioSourceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMohAudioSource(\StructType\RemoveMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveDhcpServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDhcpServer(\StructType\RemoveDhcpServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveDhcpSubnetReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDhcpSubnet(\StructType\RemoveDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCallParkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCallPark(\StructType\RemoveCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveDirectedCallParkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDirectedCallPark(\StructType\RemoveDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveMeetMeReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMeetMe(\StructType\RemoveMeetMeReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeConferenceNow
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveConferenceNowReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeConferenceNow(\StructType\RemoveConferenceNowReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeConferenceNow($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveMobileVoiceAccessReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMobileVoiceAccess(\StructType\RemoveMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRouteList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeUser(\StructType\RemoveUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveAppUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeAppUser(\StructType\RemoveAppUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveSipRealmReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSipRealm(\StructType\RemoveSipRealmReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemovePhoneNtpReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removePhoneNtp(\StructType\RemovePhoneNtpReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDateTimeGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removePresenceGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGeoLocation(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSrst(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveMlppDomainReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMlppDomain(\StructType\RemoveMlppDomainReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCumaServerSecurityProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveApplicationServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeApplicationServer(\StructType\RemoveApplicationServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveApplicationUserCapfProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeApplicationUserCapfProfile(\StructType\RemoveApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveEndUserCapfProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeEndUserCapfProfile(\StructType\RemoveEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGeoLocationFilter(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVoiceMailProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVoiceMailPort(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGatekeeper(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removePhoneButtonTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCommonPhoneConfig(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveMessageWaitingReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMessageWaiting(\StructType\RemoveMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveIpPhoneServicesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeIpPhoneServices(\StructType\RemoveIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCtiRoutePoint(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveTransPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeTransPattern(\StructType\RemoveTransPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCallingPartyTransformationPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCallingPartyTransformationPattern(\StructType\RemoveCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveSipRoutePatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSipRoutePattern(\StructType\RemoveSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveHuntPilotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeHuntPilot(\StructType\RemoveHuntPilotReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveRoutePatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRoutePattern(\StructType\RemoveRoutePatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeApplicationDialRules(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDirectoryLookupDialRules(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removePhoneSecurityProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSipDialRules(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeConferenceBridge(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMtp(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRemoteDestinationProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveLineReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLine(\StructType\RemoveLineReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDefaultDeviceProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeH323Phone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeH323Trunk(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removePhone(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeH323Gateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDeviceProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveRemoteDestinationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRemoteDestination(\StructType\RemoveRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveVg224Req $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVg224(\StructType\RemoveVg224Req $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGateway(\StructType\RemoveGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointAnalogAccess(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessPri(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessBri(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGatewayEndpointDigitalAccessT1(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst600024PortFXSGateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000E1VoIPGateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000T1VoIPGatewayPri(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCiscoCatalyst6000T1VoIPGatewayT1(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCallPickupGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCallPickupGroup(\StructType\RemoveCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGeoLocationPolicy(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSipTrunk(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCalledPartyTransformationPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCalledPartyTransformationPattern(\StructType\RemoveCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeExternalCallControlProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSafSecurityProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSafForwarder(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCcdHostedDNReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCcdHostedDN(\StructType\RemoveCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCcdHostedDNGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCcdRequestingService(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveRemoteClusterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeRemoteCluster(\StructType\RemoveRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCcdAdvertisingService(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLdapDirectory(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSafCcdPurgeBlockLearnedRoutes(\StructType\RemoveSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVpnGateway(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVpnGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVpnProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeServer(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeRouteFilterGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeRouteFilterElement(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeClient(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveImeEnrolledPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeEnrolledPattern(\StructType\RemoveImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeEnrolledPatternGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveImeExclusionNumberReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeExclusionNumber(\StructType\RemoveImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeExclusionNumberGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeFirewall(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeE164Transformation(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeTransformationProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeFallbackProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLdapFilter(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeFeatureControlPolicy(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeMobilityProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * removeEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeEnterpriseFeatureAccessConfiguration(\StructType\RemoveEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveHandoffConfigurationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeHandoffConfiguration(\StructType\RemoveHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCalledPartyTracing
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCalledPartyTracingReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCalledPartyTracing(\StructType\RemoveCalledPartyTracingReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCalledPartyTracing($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSIPNormalizationScript(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCustomUserFieldReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCustomUserField(\StructType\RemoveCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGatewaySccpEndpoints(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLbmGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeAnnouncement(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeServiceProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveLdapSyncCustomFieldReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLdapSyncCustomField(\StructType\RemoveLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeAudioCodecPreferenceList(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeUcService(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLbmHubGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImportedDirectoryUriCatalogs(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeVohServer(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeSdpTransparencyProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeFeatureGroupTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeDirNumberAliasLookupandSync(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveAdvertisedPatternsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeAdvertisedPatterns(\StructType\RemoveAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveBlockedLearnedPatternsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeBlockedLearnedPatterns(\StructType\RemoveBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveCCAProfilesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeCCAProfiles(\StructType\RemoveCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeUniversalDeviceTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeUserProfileProvision(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removePresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removePresenceRedundancyGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removePresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeWifiHotspot(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeWlanProfileGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeWLANProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeUniversalLineTemplate(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeNetworkAccessProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeHttpProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeHttpProfile(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeHttpProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeElinGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NameAndGUIDRequest $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeElinGroup(\StructType\NameAndGUIDRequest $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeElinGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeApplicationToSoftkeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveApplicationToSoftkeyTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeApplicationToSoftkeyTemplate(\StructType\RemoveApplicationToSoftkeyTemplateReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeApplicationToSoftkeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeUnitsToGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveUnitsToGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeUnitsToGateway(\StructType\RemoveUnitsToGatewayReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeUnitsToGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeGatewaySubunits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveGatewaySubunitsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeGatewaySubunits(\StructType\RemoveGatewaySubunitsReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeGatewaySubunits($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveImeLearnedRoutesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeImeLearnedRoutes(\StructType\RemoveImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveAppServerInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeAppServerInfo(\StructType\RemoveAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveSNMPCommunityStringReq $axlParams
     * @return \StructType\RemoveSNMPCommunityStringRes|bool
     */
    public function removeSNMPCommunityString(\StructType\RemoveSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveSNMPUserReq $axlParams
     * @return \StructType\RemoveSNMPUserRes|bool
     */
    public function removeSNMPUser(\StructType\RemoveSNMPUserReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveBillingServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeBillingServer(\StructType\RemoveBillingServerReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named removeLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveLocalRouteGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function removeLocalRouteGroup(\StructType\RemoveLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult(self::getSoapClient()->removeLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveSNMPCommunityStringRes|\StructType\RemoveSNMPUserRes|\StructType\StandardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
