<?php

namespace EnumType;

/**
 * This class stands for XVMAvoidancePolicy EnumType
 * @subpackage Enumerations
 */
class XVMAvoidancePolicy
{
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'Timer Control'
     * @return string 'Timer Control'
     */
    const VALUE_TIMER_CONTROL = 'Timer Control';
    /**
     * Constant for value 'User Control'
     * @return string 'User Control'
     */
    const VALUE_USER_CONTROL = 'User Control';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_TIMER_CONTROL
     * @uses self::VALUE_USER_CONTROL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_TIMER_CONTROL,
            self::VALUE_USER_CONTROL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
