<?php

namespace EnumType;

/**
 * This class stands for XUserLocale EnumType
 * @subpackage Enumerations
 */
class XUserLocale
{
    /**
     * Constant for value 'English United States'
     * @return string 'English United States'
     */
    const VALUE_ENGLISH_UNITED_STATES = 'English United States';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENGLISH_UNITED_STATES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENGLISH_UNITED_STATES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
