<?php

namespace EnumType;

/**
 * This class stands for XSipSessionRefreshMethod EnumType
 * @subpackage Enumerations
 */
class XSipSessionRefreshMethod
{
    /**
     * Constant for value 'Invite'
     * @return string 'Invite'
     */
    const VALUE_INVITE = 'Invite';
    /**
     * Constant for value 'Update'
     * @return string 'Update'
     */
    const VALUE_UPDATE = 'Update';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INVITE
     * @uses self::VALUE_UPDATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVITE,
            self::VALUE_UPDATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
