<?php

namespace EnumType;

/**
 * This class stands for XSIPBandwidthModifier EnumType
 * @subpackage Enumerations
 */
class XSIPBandwidthModifier
{
    /**
     * Constant for value 'TIAS and AS'
     * @return string 'TIAS and AS'
     */
    const VALUE_TIAS_AND_AS = 'TIAS and AS';
    /**
     * Constant for value 'TIAS only'
     * @return string 'TIAS only'
     */
    const VALUE_TIAS_ONLY = 'TIAS only';
    /**
     * Constant for value 'AS only'
     * @return string 'AS only'
     */
    const VALUE_AS_ONLY = 'AS only';
    /**
     * Constant for value 'CT only'
     * @return string 'CT only'
     */
    const VALUE_CT_ONLY = 'CT only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TIAS_AND_AS
     * @uses self::VALUE_TIAS_ONLY
     * @uses self::VALUE_AS_ONLY
     * @uses self::VALUE_CT_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TIAS_AND_AS,
            self::VALUE_TIAS_ONLY,
            self::VALUE_AS_ONLY,
            self::VALUE_CT_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
