<?php

namespace EnumType;

/**
 * This class stands for XRecordingFlag EnumType
 * @subpackage Enumerations
 */
class XRecordingFlag
{
    /**
     * Constant for value 'Call Recording Disabled'
     * @return string 'Call Recording Disabled'
     */
    const VALUE_CALL_RECORDING_DISABLED = 'Call Recording Disabled';
    /**
     * Constant for value 'Automatic Call Recording Enabled'
     * @return string 'Automatic Call Recording Enabled'
     */
    const VALUE_AUTOMATIC_CALL_RECORDING_ENABLED = 'Automatic Call Recording Enabled';
    /**
     * Constant for value 'Selective Call Recording Enabled'
     * @return string 'Selective Call Recording Enabled'
     */
    const VALUE_SELECTIVE_CALL_RECORDING_ENABLED = 'Selective Call Recording Enabled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CALL_RECORDING_DISABLED
     * @uses self::VALUE_AUTOMATIC_CALL_RECORDING_ENABLED
     * @uses self::VALUE_SELECTIVE_CALL_RECORDING_ENABLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CALL_RECORDING_DISABLED,
            self::VALUE_AUTOMATIC_CALL_RECORDING_ENABLED,
            self::VALUE_SELECTIVE_CALL_RECORDING_ENABLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
