<?php

namespace EnumType;

/**
 * This class stands for XPickupNotification EnumType
 * @subpackage Enumerations
 */
class XPickupNotification
{
    /**
     * Constant for value 'No Alert'
     * @return string 'No Alert'
     */
    const VALUE_NO_ALERT = 'No Alert';
    /**
     * Constant for value 'Audio Alert'
     * @return string 'Audio Alert'
     */
    const VALUE_AUDIO_ALERT = 'Audio Alert';
    /**
     * Constant for value 'Visual Alert'
     * @return string 'Visual Alert'
     */
    const VALUE_VISUAL_ALERT = 'Visual Alert';
    /**
     * Constant for value 'Audio and Visual Alert'
     * @return string 'Audio and Visual Alert'
     */
    const VALUE_AUDIO_AND_VISUAL_ALERT = 'Audio and Visual Alert';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_ALERT
     * @uses self::VALUE_AUDIO_ALERT
     * @uses self::VALUE_VISUAL_ALERT
     * @uses self::VALUE_AUDIO_AND_VISUAL_ALERT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_ALERT,
            self::VALUE_AUDIO_ALERT,
            self::VALUE_VISUAL_ALERT,
            self::VALUE_AUDIO_AND_VISUAL_ALERT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
